/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Date;
import java.util.TaskQueue;
import java.util.TimerTask;
import java.util.TimerThread;

public class Timer {
    private TaskQueue queue = new TaskQueue();
    private TimerThread thread = new TimerThread(this.queue);
    private Object threadReaper = new Object(this){
        private final Timer this$0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            TaskQueue taskQueue = Timer.access$000(this.this$0);
            synchronized (taskQueue) {
                Timer.access$100((Timer)this.this$0).newTasksMayBeScheduled = false;
                Timer.access$000(this.this$0).notify();
            }
        }
        {
            this.this$0 = timer;
        }
    };

    public Timer() {
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        TaskQueue taskQueue = this.queue;
        synchronized (taskQueue) {
            this.thread.newTasksMayBeScheduled = false;
            this.queue.clear();
            this.queue.notify();
        }
    }

    public Timer(boolean bl2) {
        this.thread.setDaemon(bl2);
        this.thread.start();
    }

    public void schedule(TimerTask timerTask, long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Negative delay.");
        }
        this.sched(timerTask, System.currentTimeMillis() + l2, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sched(TimerTask timerTask, long l2, long l3) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Illegal execution time.");
        }
        TaskQueue taskQueue = this.queue;
        synchronized (taskQueue) {
            if (!this.thread.newTasksMayBeScheduled) {
                throw new IllegalStateException("Timer already cancelled.");
            }
            Object object = timerTask.lock;
            synchronized (object) {
                if (timerTask.state != 0) {
                    throw new IllegalStateException("Task already scheduled or cancelled");
                }
                timerTask.nextExecutionTime = l2;
                timerTask.period = l3;
                timerTask.state = 1;
            }
            this.queue.add(timerTask);
            if (this.queue.getMin() == timerTask) {
                this.queue.notify();
            }
        }
    }

    public void schedule(TimerTask timerTask, long l2, long l3) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Negative delay.");
        }
        if (l3 <= 0L) {
            throw new IllegalArgumentException("Non-positive period.");
        }
        this.sched(timerTask, System.currentTimeMillis() + l2, -l3);
    }

    public void scheduleAtFixedRate(TimerTask timerTask, long l2, long l3) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Negative delay.");
        }
        if (l3 <= 0L) {
            throw new IllegalArgumentException("Non-positive period.");
        }
        this.sched(timerTask, System.currentTimeMillis() + l2, l3);
    }

    public void schedule(TimerTask timerTask, Date date) {
        this.sched(timerTask, date.getTime(), 0L);
    }

    public void schedule(TimerTask timerTask, Date date, long l2) {
        if (l2 <= 0L) {
            throw new IllegalArgumentException("Non-positive period.");
        }
        this.sched(timerTask, date.getTime(), -l2);
    }

    public void scheduleAtFixedRate(TimerTask timerTask, Date date, long l2) {
        if (l2 <= 0L) {
            throw new IllegalArgumentException("Non-positive period.");
        }
        this.sched(timerTask, date.getTime(), l2);
    }

    static TaskQueue access$000(Timer timer) {
        return timer.queue;
    }

    static TimerThread access$100(Timer timer) {
        return timer.thread;
    }
}

