/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AccessController;
import java.security.Identity;
import java.security.KeyManagementException;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PublicKey;
import java.security.Security;
import java.util.Enumeration;

public abstract class IdentityScope
extends Identity {
    private static IdentityScope scope;

    public abstract int size();

    protected IdentityScope() {
        this("restoring...");
    }

    private static void initializeSystemScope() {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Security.getProperty("system.scope");
            }
        });
        if (string == null) {
            return;
        }
        try {
            Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Security.error("unable to establish a system scope from " + string);
            classNotFoundException.printStackTrace();
        }
    }

    public String toString() {
        return super.toString() + "[" + this.size() + "]";
    }

    public IdentityScope(String string) {
        super(string);
    }

    private static void check(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess(string);
        }
    }

    public abstract void addIdentity(Identity var1) throws KeyManagementException;

    public abstract void removeIdentity(Identity var1) throws KeyManagementException;

    public static IdentityScope getSystemScope() {
        if (scope == null) {
            IdentityScope.initializeSystemScope();
        }
        return scope;
    }

    protected static void setSystemScope(IdentityScope identityScope) {
        IdentityScope.check("setSystemScope");
        scope = identityScope;
    }

    public abstract Enumeration identities();

    public abstract Identity getIdentity(String var1);

    public Identity getIdentity(Principal principal) {
        return this.getIdentity(principal.getName());
    }

    public abstract Identity getIdentity(PublicKey var1);

    public IdentityScope(String string, IdentityScope identityScope) throws KeyManagementException {
        super(string, identityScope);
    }
}

