/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Hashtable;

public class PixelGrabber
implements ImageConsumer {
    ImageProducer producer;
    int dstX;
    int dstY;
    int dstW;
    int dstH;
    ColorModel imageModel;
    byte[] bytePixels;
    int[] intPixels;
    int dstOff;
    int dstScan;
    private boolean grabbing;
    private int flags;
    private static final int GRABBEDBITS = 48;
    private static final int DONEBITS = 112;

    public synchronized int getHeight() {
        return this.dstH < 0 ? -1 : this.dstH;
    }

    public synchronized int getStatus() {
        return this.flags;
    }

    public synchronized int getWidth() {
        return this.dstW < 0 ? -1 : this.dstW;
    }

    public synchronized int status() {
        return this.flags;
    }

    public synchronized void abortGrabbing() {
        this.imageComplete(4);
    }

    private void convertToRGB() {
        int n2 = this.dstW * this.dstH;
        int[] nArray = new int[n2];
        if (this.bytePixels != null) {
            for (int i2 = 0; i2 < n2; ++i2) {
                nArray[i2] = this.imageModel.getRGB(this.bytePixels[i2] & 0xFF);
            }
        } else if (this.intPixels != null) {
            for (int i3 = 0; i3 < n2; ++i3) {
                nArray[i3] = this.imageModel.getRGB(this.intPixels[i3]);
            }
        }
        this.bytePixels = null;
        this.intPixels = nArray;
        this.dstScan = this.dstW;
        this.dstOff = 0;
        this.imageModel = ColorModel.getRGBdefault();
    }

    public synchronized void startGrabbing() {
        if ((this.flags & 0x70) != 0) {
            return;
        }
        if (!this.grabbing) {
            this.grabbing = true;
            this.flags &= 0xFFFFFF7F;
            this.producer.startProduction(this);
        }
    }

    public boolean grabPixels() throws InterruptedException {
        return this.grabPixels(0L);
    }

    public synchronized void imageComplete(int n2) {
        this.grabbing = false;
        switch (n2) {
            default: {
                this.flags |= 0xC0;
                break;
            }
            case 4: {
                this.flags |= 0x80;
                break;
            }
            case 3: {
                this.flags |= 0x20;
                break;
            }
            case 2: {
                this.flags |= 0x10;
            }
        }
        this.producer.removeConsumer(this);
        this.notifyAll();
    }

    public void setHints(int n2) {
    }

    public void setDimensions(int n2, int n3) {
        if (this.dstW < 0) {
            this.dstW = n2 - this.dstX;
        }
        if (this.dstH < 0) {
            this.dstH = n3 - this.dstY;
        }
        if (this.dstW <= 0 || this.dstH <= 0) {
            this.imageComplete(3);
        } else if (this.intPixels == null && this.imageModel == ColorModel.getRGBdefault()) {
            this.intPixels = new int[this.dstW * this.dstH];
            this.dstScan = this.dstW;
            this.dstOff = 0;
        }
        this.flags |= 3;
    }

    public synchronized boolean grabPixels(long l2) throws InterruptedException {
        if ((this.flags & 0x70) != 0) {
            return (this.flags & 0x30) != 0;
        }
        long l3 = l2 + System.currentTimeMillis();
        if (!this.grabbing) {
            this.grabbing = true;
            this.flags &= 0xFFFFFF7F;
            this.producer.startProduction(this);
        }
        while (this.grabbing) {
            long l4;
            if (l2 == 0L) {
                l4 = 0L;
            } else {
                l4 = l3 - System.currentTimeMillis();
                if (l4 <= 0L) break;
            }
            this.wait(l4);
        }
        return (this.flags & 0x30) != 0;
    }

    public PixelGrabber(Image image, int n2, int n3, int n4, int n5, boolean bl2) {
        this.producer = image.getSource();
        this.dstX = n2;
        this.dstY = n3;
        this.dstW = n4;
        this.dstH = n5;
        if (bl2) {
            this.imageModel = ColorModel.getRGBdefault();
        }
    }

    public PixelGrabber(Image image, int n2, int n3, int n4, int n5, int[] nArray, int n6, int n7) {
        this(image.getSource(), n2, n3, n4, n5, nArray, n6, n7);
    }

    public synchronized ColorModel getColorModel() {
        return this.imageModel;
    }

    public void setPixels(int n2, int n3, int n4, int n5, ColorModel colorModel, byte[] byArray, int n6, int n7) {
        int n8;
        int n9;
        if (n3 < this.dstY) {
            n9 = this.dstY - n3;
            if (n9 >= n5) {
                return;
            }
            n6 += n7 * n9;
            n3 += n9;
            n5 -= n9;
        }
        if (n3 + n5 > this.dstY + this.dstH && (n5 = this.dstY + this.dstH - n3) <= 0) {
            return;
        }
        if (n2 < this.dstX) {
            n9 = this.dstX - n2;
            if (n9 >= n4) {
                return;
            }
            n6 += n9;
            n2 += n9;
            n4 -= n9;
        }
        if (n2 + n4 > this.dstX + this.dstW && (n4 = this.dstX + this.dstW - n2) <= 0) {
            return;
        }
        n9 = this.dstOff + (n3 - this.dstY) * this.dstScan + (n2 - this.dstX);
        if (this.intPixels == null) {
            if (this.bytePixels == null) {
                this.bytePixels = new byte[this.dstW * this.dstH];
                this.dstScan = this.dstW;
                this.dstOff = 0;
                this.imageModel = colorModel;
            } else if (this.imageModel != colorModel) {
                this.convertToRGB();
            }
            if (this.bytePixels != null) {
                for (n8 = n5; n8 > 0; --n8) {
                    System.arraycopy(byArray, n6, this.bytePixels, n9, n4);
                    n6 += n7;
                    n9 += this.dstScan;
                }
            }
        }
        if (this.intPixels != null) {
            n8 = this.dstScan - n4;
            int n10 = n7 - n4;
            for (int i2 = n5; i2 > 0; --i2) {
                for (int i3 = n4; i3 > 0; --i3) {
                    this.intPixels[n9++] = colorModel.getRGB(byArray[n6++] & 0xFF);
                }
                n6 += n10;
                n9 += n8;
            }
        }
        this.flags |= 8;
    }

    public void setPixels(int n2, int n3, int n4, int n5, ColorModel colorModel, int[] nArray, int n6, int n7) {
        int n8;
        if (n3 < this.dstY) {
            n8 = this.dstY - n3;
            if (n8 >= n5) {
                return;
            }
            n6 += n7 * n8;
            n3 += n8;
            n5 -= n8;
        }
        if (n3 + n5 > this.dstY + this.dstH && (n5 = this.dstY + this.dstH - n3) <= 0) {
            return;
        }
        if (n2 < this.dstX) {
            n8 = this.dstX - n2;
            if (n8 >= n4) {
                return;
            }
            n6 += n8;
            n2 += n8;
            n4 -= n8;
        }
        if (n2 + n4 > this.dstX + this.dstW && (n4 = this.dstX + this.dstW - n2) <= 0) {
            return;
        }
        if (this.intPixels == null) {
            if (this.bytePixels == null) {
                this.intPixels = new int[this.dstW * this.dstH];
                this.dstScan = this.dstW;
                this.dstOff = 0;
                this.imageModel = colorModel;
            } else {
                this.convertToRGB();
            }
        }
        n8 = this.dstOff + (n3 - this.dstY) * this.dstScan + (n2 - this.dstX);
        if (this.imageModel == colorModel) {
            for (int i2 = n5; i2 > 0; --i2) {
                System.arraycopy(nArray, n6, this.intPixels, n8, n4);
                n6 += n7;
                n8 += this.dstScan;
            }
        } else {
            if (this.imageModel != ColorModel.getRGBdefault()) {
                this.convertToRGB();
            }
            int n9 = this.dstScan - n4;
            int n10 = n7 - n4;
            for (int i3 = n5; i3 > 0; --i3) {
                for (int i4 = n4; i4 > 0; --i4) {
                    this.intPixels[n8++] = colorModel.getRGB(nArray[n6++]);
                }
                n6 += n10;
                n8 += n9;
            }
        }
        this.flags |= 8;
    }

    public void setColorModel(ColorModel colorModel) {
    }

    public PixelGrabber(ImageProducer imageProducer, int n2, int n3, int n4, int n5, int[] nArray, int n6, int n7) {
        this.producer = imageProducer;
        this.dstX = n2;
        this.dstY = n3;
        this.dstW = n4;
        this.dstH = n5;
        this.dstOff = n6;
        this.dstScan = n7;
        this.intPixels = nArray;
        this.imageModel = ColorModel.getRGBdefault();
    }

    public synchronized Object getPixels() {
        return this.bytePixels == null ? this.intPixels : (int[])this.bytePixels;
    }

    public void setProperties(Hashtable hashtable) {
    }
}

