/*
 * Decompiled with CFR 0.152.
 */
package java.awt.datatransfer;

import java.awt.datatransfer.MimeType;
import java.awt.datatransfer.MimeTypeParameterList;
import java.awt.datatransfer.MimeTypeParseException;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OptionalDataException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import sun.awt.datatransfer.DataTransferer;

public class DataFlavor
implements Externalizable,
Cloneable {
    private static final long serialVersionUID = 8367026044764648243L;
    private static final Class ioInputStreamClass = class$java$io$InputStream == null ? (class$java$io$InputStream = DataFlavor.class$("java.io.InputStream")) : class$java$io$InputStream;
    public static final DataFlavor stringFlavor = DataFlavor.createConstant(class$java$lang$String == null ? (class$java$lang$String = DataFlavor.class$("java.lang.String")) : class$java$lang$String, "Unicode String");
    public static final DataFlavor imageFlavor = DataFlavor.createConstant("image/x-java-image; class=java.awt.Image", "Image");
    public static final DataFlavor plainTextFlavor = DataFlavor.createConstant("text/plain; charset=unicode; class=java.io.InputStream", "Plain Text");
    public static final String javaSerializedObjectMimeType = "application/x-java-serialized-object";
    public static final DataFlavor javaFileListFlavor = DataFlavor.createConstant("application/x-java-file-list;class=java.util.List", null);
    public static final String javaJVMLocalObjectMimeType = "application/x-java-jvm-local-objectref";
    public static final String javaRemoteObjectMimeType = "application/x-java-remote-object";
    private static Comparator textFlavorComparator;
    transient int atom;
    MimeType mimeType;
    private String humanPresentableName;
    private Class representationClass;
    static Class class$java$io$InputStream;
    static Class class$java$lang$String;
    static Class class$java$io$Reader;
    static Class class$java$nio$CharBuffer;
    static Class class$java$nio$ByteBuffer;
    static Class class$java$io$Serializable;
    static Class class$java$rmi$Remote;
    static Class class$java$util$List;

    public int hashCode() {
        int n2 = 0;
        if (this.representationClass != null) {
            n2 += this.representationClass.hashCode();
        }
        if (this.mimeType != null) {
            String string;
            String string2 = this.mimeType.getPrimaryType();
            if (string2 != null) {
                n2 += string2.hashCode();
            }
            if ("text".equals(string2) && DataTransferer.doesSubtypeSupportCharset(this) && this.representationClass != null && !this.isRepresentationClassReader() && !(class$java$lang$String == null ? (class$java$lang$String = DataFlavor.class$("java.lang.String")) : class$java$lang$String).equals(this.representationClass) && !this.isRepresentationClassCharBuffer() && !DataTransferer.charArrayClass.equals(this.representationClass) && (string = DataTransferer.canonicalName(this.getParameter("charset"))) != null) {
                n2 += string.hashCode();
            }
        }
        return n2;
    }

    public DataFlavor() {
    }

    public boolean isFlavorJavaFileListType() {
        if (this.mimeType == null || this.representationClass == null) {
            return false;
        }
        return (class$java$util$List == null ? (class$java$util$List = DataFlavor.class$("java.util.List")) : class$java$util$List).isAssignableFrom(this.representationClass) && this.mimeType.match(DataFlavor.javaFileListFlavor.mimeType);
    }

    public boolean isFlavorRemoteObjectType() {
        return this.isRepresentationClassRemote() && this.isRepresentationClassSerializable() && this.isMimeTypeEqual(javaRemoteObjectMimeType);
    }

    public boolean isFlavorSerializedObjectType() {
        return this.isRepresentationClassSerializable() && this.isMimeTypeEqual(javaSerializedObjectMimeType);
    }

    public boolean isFlavorTextType() {
        return DataTransferer.isFlavorCharsetTextType(this) || DataTransferer.isFlavorNoncharsetTextType(this);
    }

    public boolean isMimeTypeSerializedObject() {
        return this.isMimeTypeEqual(javaSerializedObjectMimeType);
    }

    public boolean isRepresentationClassByteBuffer() {
        return (class$java$nio$ByteBuffer == null ? (class$java$nio$ByteBuffer = DataFlavor.class$("java.nio.ByteBuffer")) : class$java$nio$ByteBuffer).isAssignableFrom(this.representationClass);
    }

    public boolean isRepresentationClassCharBuffer() {
        return (class$java$nio$CharBuffer == null ? (class$java$nio$CharBuffer = DataFlavor.class$("java.nio.CharBuffer")) : class$java$nio$CharBuffer).isAssignableFrom(this.representationClass);
    }

    public boolean isRepresentationClassInputStream() {
        return ioInputStreamClass.isAssignableFrom(this.representationClass);
    }

    public boolean isRepresentationClassReader() {
        return (class$java$io$Reader == null ? (class$java$io$Reader = DataFlavor.class$("java.io.Reader")) : class$java$io$Reader).isAssignableFrom(this.representationClass);
    }

    public boolean isRepresentationClassRemote() {
        return (class$java$rmi$Remote == null ? (class$java$rmi$Remote = DataFlavor.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(this.representationClass);
    }

    public boolean isRepresentationClassSerializable() {
        return (class$java$io$Serializable == null ? (class$java$io$Serializable = DataFlavor.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(this.representationClass);
    }

    public static final DataFlavor getTextPlainUnicodeFlavor() {
        String string = null;
        DataTransferer dataTransferer = DataTransferer.getInstance();
        if (dataTransferer != null) {
            string = dataTransferer.getDefaultUnicodeEncoding();
        }
        return new DataFlavor("text/plain;charset=" + string + ";class=java.io.InputStream", "Plain Text");
    }

    public boolean equals(DataFlavor dataFlavor) {
        if (dataFlavor == null) {
            return false;
        }
        if (this == dataFlavor) {
            return true;
        }
        if (this.representationClass == null ? dataFlavor.getRepresentationClass() != null : !this.representationClass.equals(dataFlavor.getRepresentationClass())) {
            return false;
        }
        if (this.mimeType == null) {
            if (dataFlavor.mimeType != null) {
                return false;
            }
        } else {
            if (!this.mimeType.match(dataFlavor.mimeType)) {
                return false;
            }
            if ("text".equals(this.getPrimaryType()) && DataTransferer.doesSubtypeSupportCharset(this) && this.representationClass != null && !this.isRepresentationClassReader() && !(class$java$lang$String == null ? (class$java$lang$String = DataFlavor.class$("java.lang.String")) : class$java$lang$String).equals(this.representationClass) && !this.isRepresentationClassCharBuffer() && !DataTransferer.charArrayClass.equals(this.representationClass)) {
                String string = DataTransferer.canonicalName(this.getParameter("charset"));
                String string2 = DataTransferer.canonicalName(dataFlavor.getParameter("charset"));
                if (string == null ? string2 != null : !string.equals(string2)) {
                    return false;
                }
            }
        }
        return true;
    }

    public final boolean isMimeTypeEqual(DataFlavor dataFlavor) {
        return this.isMimeTypeEqual(dataFlavor.mimeType);
    }

    public boolean match(DataFlavor dataFlavor) {
        return this.equals(dataFlavor);
    }

    private boolean isMimeTypeEqual(MimeType mimeType) {
        if (this.mimeType == null) {
            return mimeType == null;
        }
        return this.mimeType.match(mimeType);
    }

    public synchronized void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        block4: {
            String string = null;
            this.mimeType = (MimeType)objectInput.readObject();
            if (this.mimeType != null) {
                this.humanPresentableName = this.mimeType.getParameter("humanPresentableName");
                this.mimeType.removeParameter("humanPresentableName");
                string = this.mimeType.getParameter("class");
                if (string == null) {
                    throw new IOException("no class parameter specified in: " + this.mimeType);
                }
            }
            try {
                this.representationClass = (Class)objectInput.readObject();
            }
            catch (OptionalDataException optionalDataException) {
                if (string == null) break block4;
                this.representationClass = DataFlavor.tryToLoadClass(string, this.getClass().getClassLoader());
            }
        }
    }

    public synchronized void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (this.mimeType != null) {
            this.mimeType.setParameter("humanPresentableName", this.humanPresentableName);
            objectOutput.writeObject(this.mimeType);
            this.mimeType.removeParameter("humanPresentableName");
        } else {
            objectOutput.writeObject(null);
        }
        objectOutput.writeObject(this.representationClass);
    }

    public final Class getDefaultRepresentationClass() {
        return ioInputStreamClass;
    }

    public Class getRepresentationClass() {
        return this.representationClass;
    }

    public Object clone() throws CloneNotSupportedException {
        Object object = super.clone();
        if (this.mimeType != null) {
            ((DataFlavor)object).mimeType = (MimeType)this.mimeType.clone();
        }
        return object;
    }

    public boolean equals(Object object) {
        return object instanceof DataFlavor && this.equals((DataFlavor)object);
    }

    public final String getDefaultRepresentationClassAsString() {
        return this.getDefaultRepresentationClass().getName();
    }

    public String getHumanPresentableName() {
        return this.humanPresentableName;
    }

    public String getMimeType() {
        return this.mimeType != null ? this.mimeType.toString() : null;
    }

    public String getPrimaryType() {
        return this.mimeType != null ? this.mimeType.getPrimaryType() : null;
    }

    public String getSubType() {
        return this.mimeType != null ? this.mimeType.getSubType() : null;
    }

    private String paramString() {
        String string = "";
        string = string + "mimetype=";
        string = this.mimeType == null ? string + "null" : string + this.mimeType.getBaseType();
        string = string + ";representationclass=";
        string = this.representationClass == null ? string + "null" : string + this.representationClass.getName();
        if (DataTransferer.isFlavorCharsetTextType(this) && (this.isRepresentationClassInputStream() || this.isRepresentationClassByteBuffer() || DataTransferer.byteArrayClass.equals(this.representationClass))) {
            string = string + ";charset=" + DataTransferer.getTextCharset(this);
        }
        return string;
    }

    public String toString() {
        String string = this.getClass().getName();
        string = string + "[" + this.paramString() + "]";
        return string;
    }

    public DataFlavor(String string) throws ClassNotFoundException {
        if (string == null) {
            throw new NullPointerException("mimeType");
        }
        try {
            this.initialize(string, null, this.getClass().getClassLoader());
        }
        catch (MimeTypeParseException mimeTypeParseException) {
            throw new IllegalArgumentException("failed to parse:" + string);
        }
    }

    public void setHumanPresentableName(String string) {
        this.humanPresentableName = string;
    }

    public boolean equals(String string) {
        if (string == null || this.mimeType == null) {
            return false;
        }
        return this.isMimeTypeEqual(string);
    }

    public boolean isMimeTypeEqual(String string) {
        if (string == null) {
            throw new NullPointerException("mimeType");
        }
        if (this.mimeType == null) {
            return false;
        }
        try {
            return this.mimeType.match(new MimeType(string));
        }
        catch (MimeTypeParseException mimeTypeParseException) {
            return false;
        }
    }

    public static final DataFlavor selectBestTextFlavor(DataFlavor[] dataFlavorArray) {
        DataFlavor dataFlavor;
        if (dataFlavorArray == null || dataFlavorArray.length == 0) {
            return null;
        }
        if (textFlavorComparator == null) {
            textFlavorComparator = new TextFlavorComparator();
        }
        if (!(dataFlavor = (DataFlavor)Collections.max(Arrays.asList(dataFlavorArray), textFlavorComparator)).isFlavorTextType()) {
            return null;
        }
        return dataFlavor;
    }

    public Reader getReaderForText(Transferable transferable) throws UnsupportedFlavorException, IOException {
        Object object;
        Object object2 = transferable.getTransferData(this);
        if (object2 == null) {
            throw new IllegalArgumentException("getTransferData() returned null");
        }
        if (object2 instanceof Reader) {
            return (Reader)object2;
        }
        if (object2 instanceof String) {
            return new StringReader((String)object2);
        }
        if (object2 instanceof CharBuffer) {
            CharBuffer charBuffer = (CharBuffer)object2;
            int n2 = charBuffer.remaining();
            char[] cArray = new char[n2];
            charBuffer.get(cArray, 0, n2);
            return new CharArrayReader(cArray);
        }
        if (object2 instanceof char[]) {
            return new CharArrayReader((char[])object2);
        }
        InputStream inputStream = null;
        if (object2 instanceof InputStream) {
            inputStream = (InputStream)object2;
        } else if (object2 instanceof ByteBuffer) {
            object = (ByteBuffer)object2;
            int n3 = ((Buffer)object).remaining();
            byte[] byArray = new byte[n3];
            ((ByteBuffer)object).get(byArray, 0, n3);
            inputStream = new ByteArrayInputStream(byArray);
        } else if (object2 instanceof byte[]) {
            inputStream = new ByteArrayInputStream((byte[])object2);
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("transfer data is not Reader, String, CharBuffer, char array, InputStream, ByteBuffer, or byte array");
        }
        object = this.getParameter("charset");
        return object == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, (String)object);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public DataFlavor(Class clazz, String string) {
        this("application", "x-java-serialized-object", null, clazz, string);
        if (clazz == null) {
            throw new NullPointerException("representationClass");
        }
    }

    public String getParameter(String string) {
        if (string.equals("humanPresentableName")) {
            return this.humanPresentableName;
        }
        return this.mimeType != null ? this.mimeType.getParameter(string) : null;
    }

    protected String normalizeMimeType(String string) {
        return string;
    }

    public DataFlavor(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("mimeType");
        }
        try {
            this.initialize(string, string2, this.getClass().getClassLoader());
        }
        catch (MimeTypeParseException mimeTypeParseException) {
            throw new IllegalArgumentException("failed to parse:" + string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("can't find specified class: " + classNotFoundException.getMessage());
        }
    }

    private static DataFlavor createConstant(Class clazz, String string) {
        try {
            return new DataFlavor(clazz, string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static DataFlavor createConstant(String string, String string2) {
        try {
            return new DataFlavor(string, string2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected static final Class tryToLoadClass(String string, ClassLoader classLoader) throws ClassNotFoundException {
        ClassLoader classLoader2 = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                return classLoader != null ? classLoader : ClassLoader.getSystemClassLoader();
            }
        });
        try {
            return Class.forName(string, true, classLoader2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (classLoader != null) {
                return Class.forName(string, true, classLoader);
            }
            throw new ClassNotFoundException(string);
        }
    }

    public DataFlavor(String string, String string2, ClassLoader classLoader) throws ClassNotFoundException {
        if (string == null) {
            throw new NullPointerException("mimeType");
        }
        try {
            this.initialize(string, string2, classLoader);
        }
        catch (MimeTypeParseException mimeTypeParseException) {
            throw new IllegalArgumentException("failed to parse:" + string);
        }
    }

    private void initialize(String string, String string2, ClassLoader classLoader) throws MimeTypeParseException, ClassNotFoundException {
        if (string == null) {
            throw new NullPointerException("mimeType");
        }
        this.mimeType = new MimeType(string);
        String string3 = this.getParameter("class");
        if (string3 == null) {
            if (javaSerializedObjectMimeType.equals(this.mimeType.getBaseType())) {
                throw new IllegalArgumentException("no representation class specified for:" + string);
            }
            this.representationClass = class$java$io$InputStream == null ? (class$java$io$InputStream = DataFlavor.class$("java.io.InputStream")) : class$java$io$InputStream;
        } else {
            this.representationClass = DataFlavor.tryToLoadClass(string3, classLoader);
        }
        this.mimeType.setParameter("class", this.representationClass.getName());
        if (string2 == null && (string2 = this.mimeType.getParameter("humanPresentableName")) == null) {
            string2 = this.mimeType.getPrimaryType() + "/" + this.mimeType.getSubType();
        }
        this.humanPresentableName = string2;
        this.mimeType.removeParameter("humanPresentableName");
    }

    protected String normalizeMimeTypeParameter(String string, String string2) {
        return string2;
    }

    private DataFlavor(String string, String string2, MimeTypeParameterList mimeTypeParameterList, Class clazz, String string3) {
        if (string == null) {
            throw new NullPointerException("primaryType");
        }
        if (string2 == null) {
            throw new NullPointerException("subType");
        }
        if (clazz == null) {
            throw new NullPointerException("representationClass");
        }
        if (mimeTypeParameterList == null) {
            mimeTypeParameterList = new MimeTypeParameterList();
        }
        mimeTypeParameterList.set("class", clazz.getName());
        if (string3 == null && (string3 = mimeTypeParameterList.get("humanPresentableName")) == null) {
            string3 = string + "/" + string2;
        }
        try {
            this.mimeType = new MimeType(string, string2, mimeTypeParameterList);
        }
        catch (MimeTypeParseException mimeTypeParseException) {
            throw new IllegalArgumentException("MimeType Parse Exception: " + mimeTypeParseException.getMessage());
        }
        this.representationClass = clazz;
        this.humanPresentableName = string3;
        this.mimeType.removeParameter("humanPresentableName");
    }

    static class TextFlavorComparator
    extends DataTransferer.DataFlavorComparator {
        TextFlavorComparator() {
        }

        public int compare(Object object, Object object2) {
            DataFlavor dataFlavor = (DataFlavor)object;
            DataFlavor dataFlavor2 = (DataFlavor)object2;
            if (dataFlavor.isFlavorTextType()) {
                if (dataFlavor2.isFlavorTextType()) {
                    return super.compare(object, object2);
                }
                return 1;
            }
            if (dataFlavor2.isFlavorTextType()) {
                return -1;
            }
            return 0;
        }
    }
}

