/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractMidiDevice;
import com.sun.media.sound.AbstractMidiDeviceProvider;
import com.sun.media.sound.FastShortMessage;
import com.sun.media.sound.FastSysexMessage;
import com.sun.media.sound.MidiInDeviceProvider;
import java.util.Vector;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Transmitter;

class MidiInDevice
extends AbstractMidiDevice
implements Runnable {
    private Thread midiInThread = null;
    private Vector transmitters = new Vector();

    public int getMaxTransmitters() {
        return -1;
    }

    synchronized void implClose() {
        long l2 = this.id;
        this.id = 0L;
        for (int i2 = 0; i2 < this.transmitters.size(); ++i2) {
            ((Transmitter)this.transmitters.elementAt(i2)).close();
        }
        this.transmitters.removeAllElements();
        this.nStop(l2);
        this.nClose(l2);
    }

    synchronized void implOpen() throws MidiUnavailableException {
        this.id = this.nOpen(((MidiInDeviceProvider.MidiInDeviceInfo)this.getDeviceInfo()).getIndex());
        if (this.id == 0L) {
            throw new MidiUnavailableException("Unable to open native device");
        }
        if (this.midiInThread == null) {
            this.midiInThread = new Thread(this);
            this.midiInThread.start();
        }
        this.nStart(this.id);
    }

    public void run() {
        while (this.id != 0L) {
            this.nGetMessages(this.id);
            if (this.id == 0L) continue;
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.midiInThread = null;
    }

    private native long nOpen(int var1) throws MidiUnavailableException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callbackShortMessage(int n2, long l2) {
        if (n2 == 0 || this.id == 0L) {
            return;
        }
        try {
            Vector vector = this.transmitters;
            synchronized (vector) {
                for (int i2 = 0; i2 < this.transmitters.size(); ++i2) {
                    Receiver receiver = ((Transmitter)this.transmitters.elementAt(i2)).getReceiver();
                    if (receiver == null) continue;
                    receiver.send(new FastShortMessage(n2), l2);
                }
            }
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            return;
        }
    }

    private native void nClose(long var1);

    private native void nGetMessages(long var1);

    private native void nStart(long var1) throws MidiUnavailableException;

    private native void nStop(long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callbackLongMessage(byte[] byArray, long l2) {
        if (this.id == 0L || byArray == null) {
            return;
        }
        try {
            Vector vector = this.transmitters;
            synchronized (vector) {
                for (int i2 = 0; i2 < this.transmitters.size(); ++i2) {
                    Receiver receiver = ((Transmitter)this.transmitters.elementAt(i2)).getReceiver();
                    if (receiver == null) continue;
                    receiver.send(new FastSysexMessage(byArray), l2);
                }
            }
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            return;
        }
    }

    MidiInDevice(AbstractMidiDeviceProvider.Info info) {
        super(info);
    }

    public synchronized Transmitter getTransmitter() throws MidiUnavailableException {
        MidiInTransmitter midiInTransmitter = new MidiInTransmitter(this);
        this.transmitters.addElement(midiInTransmitter);
        return midiInTransmitter;
    }

    static Vector access$000(MidiInDevice midiInDevice) {
        return midiInDevice.transmitters;
    }

    class MidiInTransmitter
    implements Transmitter {
        private Receiver receiver;
        private final MidiInDevice this$0;

        public void close() {
            MidiInDevice.access$000(this.this$0).removeElement(this);
        }

        MidiInTransmitter(MidiInDevice midiInDevice) {
            this.this$0 = midiInDevice;
            this.receiver = null;
        }

        public Receiver getReceiver() {
            return this.receiver;
        }

        public void setReceiver(Receiver receiver) {
            this.receiver = receiver;
        }
    }
}

