//
//  ImportView.m
//  bPhoto
//
//  Created by Stefan Hafeneger on 29.04.09.
//  Copyright 2009 __MyCompanyName__. All rights reserved.
//

#import "ImportView.h"

#import "iPhoto.h"

@implementation ImportView

- (void)drawRect:(NSRect)rect {
    [[NSColor grayColor] setFill];
	NSRectFill([self bounds]);
}

- (void)awakeFromNib {
	[self registerForDraggedTypes:[NSArray arrayWithObject:NSFilenamesPboardType]];
}

- (NSDragOperation)draggingEntered:(id <NSDraggingInfo>)sender {
    return NSDragOperationCopy;
}

- (BOOL)performDragOperation:(id <NSDraggingInfo>)sender {
	NSArray *files = [[sender draggingPasteboard] propertyListForType:NSFilenamesPboardType];
	[self performSelector:@selector(importFiles:) withObject:files];
	return YES;
}

- (void)importFiles:(NSArray *)files {
	iPhotoApplication *iPhoto = [SBApplication applicationWithBundleIdentifier:@"com.apple.iPhoto"];
	if([iPhoto isRunning]) {
		for(iPhotoAlbum *album in [iPhoto albums]) {
			if([[album name] isEqualToString:@"bPhoto"]) {
				for(NSString *file in files) {
					[album importFrom:file forceCopy:YES to:nil];
				}
				break;
			}
		}
	}
}

@end
