//
//  DOServer.m
//  SimpleDO

#import "DOServer.h"


@implementation DOServer

- (id) init {

    if (self = [super init]) {
        listOfClients = [[NSMutableArray alloc] init];
    }
    return self;
}


- (void)addDOClient:(id)aClient
{
    [listOfClients addObject:aClient];
    NSLog(@"Added client:%@",aClient);
    
}

- (BOOL)removeDOClient:(id)aClient
{
    NSLog(@"removed client:%@",aClient);
    [listOfClients removeObject:aClient];
    return YES;
}

- (void)broadcastMessageString:(NSString *)messageString
{
    [listOfClients makeObjectsPerformSelector:@selector(appendMessageString:) withObject:messageString];
    NSLog(@"New message from server:%@", messageString);
}

- (void) dealloc {
    [listOfClients release];
    listOfClients = nil;
    [super dealloc];
}


@end
