//
//  DOController.m
//  SimpleDO
//
//  Created by Werner Lonsing on 1/13/09.
//  Copyright 2009 www.lonsing.com. All rights reserved.
//


#import "DOController.h"


@implementation DOController
@synthesize server;


- (IBAction)sendMessage:(id)sender
{
    [server broadcastMessageString:[composeView string]];
    [composeView setString:@""];
}

- (oneway void)appendMessageString:(NSString *)aString
{
    NSRange appendRange = NSMakeRange([[messageView string] length],0);
    [messageView replaceCharactersInRange:appendRange withString:aString];
    [messageView scrollRangeToVisible:appendRange];
}

// application delegate's methods
// instaniate and connect it in IB

- (void)applicationDidFinishLaunching:(NSNotification *)aNotification
{// server is NSDistantObject
    self.server = [[NSConnection rootProxyForConnectionWithRegisteredName:@"DOServer" host:nil] retain];
    
    if (nil == self.server ) {
        
        NSLog(@"Error: Failed to connect to server.");
        NSLog([[NSConnection allConnections] description]);
        
    } else {
        [self.server setProtocolForProxy:@protocol(DOProtocol)];
        [self.server addDOClient:self];
        [self.server broadcastMessageString:[NSString stringWithFormat:@"Connected: %@ %d\n",
                                        [[NSProcessInfo processInfo] processName],
                                        [[NSProcessInfo processInfo] processIdentifier]
                                        ]];
        NSLog(@"Connected to server: %@.", [self.server description]);

    }
    
}
- (void)applicationWillTerminate:(NSNotification *)aNotification
{
    if (NO == [self.server removeDOClient:self]) {
        NSLog(@"Error: Failed to remove client");
    }
    self.server = nil;
}

@end
