//
//  WeightedGrayScaleFilter.m
//  WeightedGrayScale
//
//  Created by Werner Lonsing on 2/23/08.
//  Copyright W. Lonsing 2008. All rights reserved.
//

#import "WeightedGrayScaleFilter.h"
#import <Foundation/Foundation.h>
#import <ApplicationServices/ApplicationServices.h>

@implementation WeightedGrayScaleFilter

static CIKernel *_WeightedGrayScaleFilterKernel = nil;

+ (CIFilter *)filterWithName: (NSString *)name
{
    CIFilter  *filter;
    
    filter = [[self alloc] init];
    return [filter autorelease];
}



- (id)init
{
    if(_WeightedGrayScaleFilterKernel == nil)
    {
		NSBundle    *bundle = [NSBundle bundleForClass:NSClassFromString(@"WeightedGrayScaleFilter")];
		NSString    *code = [NSString stringWithContentsOfFile:[bundle pathForResource:@"WeightedGrayScaleFilterKernel" ofType:@"cikernel"]];
		NSArray     *kernels = [CIKernel kernelsWithString:code];

		_WeightedGrayScaleFilterKernel = [[kernels objectAtIndex:0] retain];
    }
    return [super init];
}


- (CGRect)regionOf: (int)sampler  destRect: (CGRect)rect  userInfo: (NSNumber *)radius
{
    return CGRectInset(rect, -[radius floatValue], 0);
}


- (NSDictionary *)customAttributes
{
    return [NSDictionary dictionaryWithObjectsAndKeys:

            [NSDictionary dictionaryWithObjectsAndKeys:
             [NSNumber numberWithDouble:  0.00], kCIAttributeMin,
             [NSNumber numberWithDouble:  1.00], kCIAttributeMax,
             [NSNumber numberWithDouble:  0.00], kCIAttributeSliderMin,
             [NSNumber numberWithDouble:  1.00], kCIAttributeSliderMax,
             [NSNumber numberWithDouble:  0.33], kCIAttributeDefault,
             [NSNumber numberWithDouble:  1.00], kCIAttributeIdentity,
             @"NSNumber",kCIAttributeClass,
             kCIAttributeTypeScalar,           kCIAttributeType,
             nil],                               @"inputRedWeight",

            [NSDictionary dictionaryWithObjectsAndKeys:
             [NSNumber numberWithDouble:  0.00], kCIAttributeMin,
             [NSNumber numberWithDouble:  1.00], kCIAttributeMax,
             [NSNumber numberWithDouble:  0.00], kCIAttributeSliderMin,
             [NSNumber numberWithDouble:  1.00], kCIAttributeSliderMax,
             [NSNumber numberWithDouble:  0.33], kCIAttributeDefault,
             [NSNumber numberWithDouble:  1.00], kCIAttributeIdentity,
             @"NSNumber",kCIAttributeClass,
             kCIAttributeTypeScalar,           kCIAttributeType,
             nil],                               @"inputGreenWeight",
            
            [NSDictionary dictionaryWithObjectsAndKeys:
            [NSNumber numberWithDouble:  0.00], kCIAttributeMin,
            [NSNumber numberWithDouble:  1.00], kCIAttributeMax,
            [NSNumber numberWithDouble:  0.00], kCIAttributeSliderMin,
            [NSNumber numberWithDouble:  1.00], kCIAttributeSliderMax,
            [NSNumber numberWithDouble:  0.33], kCIAttributeDefault,
            [NSNumber numberWithDouble:  1.00], kCIAttributeIdentity,
             @"NSNumber",kCIAttributeClass,
             kCIAttributeTypeScalar,           kCIAttributeType,
            nil],                               @"inputBlueWeight",

        nil];
}

// called when setting up for fragment program and also calls fragment program
- (CIImage *)outputImage
{
     CISampler *src = [CISampler samplerWithImage:inputImage];
    return [self apply:_WeightedGrayScaleFilterKernel, src,inputRedWeight, inputGreenWeight, inputBlueWeight, nil];
}

@end
