//
//  NSImage_WLExtension.m
//  Clipper
//
//  Created by Werner Lonsing on 8/10/07.
//  Copyright 2007 W. Lonsing. All rights reserved.
//

#import "NSImage_WLExtension.h"


@implementation  NSImage (WLExtension) 

+ (NSImage *)imageFromCIImage: (CIImage *)ci inRect:(CGRect)r
{
    NSCIImageRep *ir = [NSCIImageRep imageRepWithCIImage:ci];
	
	NSImage *image = [[NSImage alloc] initWithSize: NSMakeSize(r.size.width, r.size.height)];
    [image addRepresentation:ir];
    return [image autorelease];
}

+ (NSImage *)imageFromCIImage: (CIImage *)ci
{
  return [self imageFromCIImage:ci inRect:[ci extent]];
}


+ (CIImage *)toCIImageFromNSImage: (NSImage *)image
{
    NSBitmapImageRep *bm = [NSBitmapImageRep imageRepWithData:[image TIFFRepresentation]];
    CIImage *im = [[CIImage alloc]  initWithBitmapImageRep:bm];
    return [im  autorelease];
}


+ (NSImage*) imageFromCGImageRef:(CGImageRef)image;
{
    NSRect imageRect = NSZeroRect;
 
    // Get the image dimensions.
    imageRect.size.height = CGImageGetHeight(image);
    imageRect.size.width = CGImageGetWidth(image);
 
    // Create a new image to receive the Quartz image data.
    NSImage* newImage = [[NSImage alloc] initWithSize:imageRect.size];

    [newImage lockFocus];
     CGContextRef imageContext = (CGContextRef)[[NSGraphicsContext currentContext] graphicsPort];

    // Get the Quartz context and draw.
    CGContextDrawImage(imageContext, *(CGRect*)&imageRect, image);
    [newImage unlockFocus];

    return [newImage autorelease];
}

@end
