//
//  WLImageViewForPath.m
//  MirrorImages
//
//  Created by Werner Lonsing on 3/4/08.
//  Copyright 2008 W. Lonsing. All rights reserved.
//

#import "WLImageViewForPath.h"


@implementation WLImageViewForPath
@synthesize url;
@synthesize filePath;

- (id)initWithFrame:(NSRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        self.url = nil;
    }
    return self;
}

- (void)concludeDragOperation:(id <NSDraggingInfo>)sender
{
    NSPasteboard *pasteboard = [sender draggingPasteboard];
    
    if ([[pasteboard types] containsObject:NSFilenamesPboardType]){

        NSArray  *types = [pasteboard propertyListForType:NSFilenamesPboardType];
        NSUInteger count = [types count];
        
        if (count > 0){
            self.filePath = [types objectAtIndex:0];
            NSURL    *newUrl= [[NSURL alloc] initFileURLWithPath:[types objectAtIndex:0]];
            self.url = newUrl;
            NSLog(@"Name in View: %@", [newUrl path]);

            [newUrl release];
        }
    }
    else if ([[pasteboard types] containsObject:NSURLPboardType]){
        NSURL    *newUrl= [NSURL URLFromPasteboard:pasteboard];
        self.filePath = [newUrl absoluteString];
        self.url = newUrl;

    }
    [super concludeDragOperation:(id <NSDraggingInfo>)sender];
}

- (BOOL)acceptsFirstResponder
{
    return NO;
}


@end
