#import "WLImageSetter.h"
#import "NSImage_ReflectionAdditions.h"
#import "NSAffineTransform_Shearing.h"

@implementation WLImageSetter

@synthesize density;
@synthesize fadeOut;
@synthesize direction;
@synthesize axisDistance;
@synthesize flaps;
@synthesize rotationAngle;
@synthesize flapRotationAngle;
@synthesize degression;

- (void)awakeFromNib
{
    if ([[self superclass] instancesRespondToSelector:@selector(awakeFromNib)]){
        [super awakeFromNib];
    };
    
   self.density = 1.0;
   self.fadeOut = 1.0;
   self.direction = WLReflectionAbove;
   self.axisDistance = 0.0;
   self.flaps = NO;
    self.rotationAngle = 1.0;
    self.flapRotationAngle = 1.0;
    self.degression = 0.3;
    
	
	[sourceImageView setImage:[NSImage imageNamed:@"rhslogo"]];
	[self setReflectedImage:sourceImageView];
}    
// There is only one action method here for the UI
- (IBAction)setReflectedImage:(id)sender {
    if(sender == reflectedImageView)
        {
            NSImage * img = [reflectedImageView image];
            [sourceImageView setImage:img];
            [sourceImageView setNeedsDisplay:YES];
            [[reflectedImageView window] setTitle:[[[reflectedImageView url] path]lastPathComponent]];
            sourceImageView.url = reflectedImageView.url;
            sourceImageView.filePath = reflectedImageView.filePath;
            
        }
    else if(sender == sourceImageView)
        {
            NSImage * img = [NSImage maskImageFromImageWithAlpha:[sourceImageView image]];
            if(img)
                [reflectedImageView setImage:img];
            else
                [reflectedImageView setImage:[sourceImageView image]];
            
            
            NSLog(@"Name: %@", [[sourceImageView url] path]);
//           img = [self shearedImage:img shearXBy: 0.5 yBy: 0.3];
//           [reflectedImageView setImage:img];
       }
    
    else
        {NSImage * img = [[sourceImageView image] reflectedImageWithDensity:self.density fadeOut:self.fadeOut direction:self.direction axisDistance:self.axisDistance rotation:self.rotationAngle flaps:self.flaps flapRotation:self.flapRotationAngle degression:degression];
           [reflectedImageView setImage:img];
            NSLog(@"Name in View: %@ (%@)", [sourceImageView.url path], [[sourceImageView url] path]);

      }

}

- (NSImage *)rotateImage:(NSImage *)srcImage angle:(CGFloat)angle
{
    NSSize existingSize = [srcImage size];
	NSSize newSize = NSMakeSize(existingSize.height, existingSize.width);
	NSImage *rotatedImage = [[[NSImage alloc] initWithSize:newSize]  
                             autorelease];
    
	[rotatedImage lockFocus];								
	[[NSGraphicsContext currentContext]  
     setImageInterpolation:NSImageInterpolationNone];
	
	NSAffineTransform *rotateTF = [NSAffineTransform transform];
	NSPoint centerPoint = NSMakePoint(newSize.width / 2,  
                                      newSize.height / 2);
	
	//translate the image to bring the rotation point to the center  (default is 0,0 ie lower left corner)
	[rotateTF translateXBy:centerPoint.x yBy:centerPoint.y];
	[rotateTF rotateByDegrees:angle];
	[rotateTF translateXBy:-centerPoint.x yBy:-centerPoint.y];
	[rotateTF concat];
    
	[srcImage drawAtPoint:NSZeroPoint fromRect:NSMakeRect(0, 0,  
                                                               newSize.width, newSize.height) operation:NSCompositeSourceOver  
                      fraction:1.0];
    
	[rotatedImage unlockFocus];
	
	return rotatedImage;	
}

- (NSImage *)shearedImage:(NSImage *)srcImage shearXBy:(CGFloat) xShear yBy:(CGFloat) yShear
{
    NSSize existingSize = [srcImage size];
	NSSize newSize = NSMakeSize( existingSize.width +  existingSize.width* xShear, existingSize.height + existingSize.height*yShear);
	NSImage *shearedImage = [[[NSImage alloc] initWithSize:newSize]  
                             autorelease];
    
	[shearedImage lockFocus];								
	[[NSGraphicsContext currentContext]  
     setImageInterpolation:NSImageInterpolationNone];
	
	NSAffineTransform *shearTransform = [NSAffineTransform transform];
	
	//translate the image to bring the rotation point to the center  (default is 0,0 ie lower left corner)
	//[rotateTF translateXBy:centerPoint.x yBy:centerPoint.y];
	[shearTransform shearXBy: xShear yBy: yShear];
	//[rotateTF translateXBy:-centerPoint.x yBy:-centerPoint.y];
	[shearTransform concat];
    
	[srcImage drawAtPoint:NSZeroPoint fromRect:NSMakeRect(0, 0,  
                                                          existingSize.width, existingSize.height) operation:NSCompositeSourceOver  
                 fraction:1.0];
    
	[shearedImage unlockFocus];
	
	return shearedImage;	
}


- (IBAction)saveDocument:(id)sender
{
    
}

- (IBAction)saveDocumentAs:(id)sender
{
    
}
- (IBAction)runPageLayout:(id)sender
{
    
}
- (IBAction)copy:(id)sender
{
    [reflectedImageView copy:sender];
}

- (IBAction)revertDocumentToSaved:(id)sender
{
    self.density = 1.0;
    self.fadeOut = 1.0;
    self.direction = WLReflectionAbove;
    self.axisDistance = 0.0;
    self.flaps = NO;
    self.rotationAngle = 1.0;
    self.flapRotationAngle = 1.0;
    self.degression = 0.3;
    
}

- (NSString *)pathToApplicationSupportFolder
{
    NSArray *applicationSupportDirectoryPaths = 
                NSSearchPathForDirectoriesInDomains(NSApplicationSupportDirectory, NSUserDomainMask, YES);
    if ([applicationSupportDirectoryPaths count] == 0) {
        // we are in trouble
        // maybe some kicks and kisses as warning here
        [NSApp terminate:self];
    }
//    NSString *placeHolderForNSString = [NSString alloc];
//    NSLog(@"%@",[placeHolderForNSString class]);
//    NSString *copyString = (NSString*)CFStringCreateCopy ( kCFAllocatorDefault, placeHolderForNSString );
    
 //   CFStringRef placeHolder = (CFStringRef)placeHolderForNSString;

    
    return [[applicationSupportDirectoryPaths objectAtIndex:0]
            stringByAppendingPathComponent:[[NSProcessInfo processInfo] processName]];
}

- (IBAction)printDocument:(id)sender
{
    NSImageFrameStyle style = [reflectedImageView imageFrameStyle];
    [self pathToApplicationSupportFolder];
    

    [reflectedImageView setImageFrameStyle:NSImageFrameNone];
    [reflectedImageView print:(id)sender];
    

    [reflectedImageView setImageFrameStyle:style];
    
        

}

//CGColorSpaceCreateWithName (kCGColorSpaceGenericGray)

- (NSRange)getViewableCharacterRangeFromTextView:(NSTextView *)theTextView{
    
    if([theTextView enclosingScrollView])
        {
            
            NSLayoutManager *layoutManager = [theTextView layoutManager];
            NSRect visibleRect = [theTextView visibleRect];
            
            NSPoint containerOrigin = [theTextView textContainerOrigin];
            visibleRect.origin.x -= containerOrigin.x;
            visibleRect.origin.y -= containerOrigin.y;
            
            NSRange glyphRange = [layoutManager glyphRangeForBoundingRect:visibleRect inTextContainer:[theTextView textContainer]];
            //            NSRange glyphRange = [layoutManager glyphRangeForBoundingRectWithoutAdditionalLayout:visibleRect inTextContainer:[theTextView textContainer]];
            
            NSRange charRange = [layoutManager characterRangeForGlyphRange:glyphRange actualGlyphRange:nil];
            return charRange;
        }
    // no scrollView, no luck
    return NSMakeRange (NSNotFound, 0);
    
}



@end
