//
//  NSImage_ReflectionAdditions.m
//  MirrorImages
//
//  Created by Werner Lonsing on 2/29/08.
//  Copyright 2008 W. Lonsing. All rights reserved.
//

#import <QuartzCore/QuartzCore.h>
#import "NSImage_ReflectionAdditions.h"
#import "NSImage_WLExtension.h"

@implementation NSImage (ReflectionAdditions)


+ (NSImage *)reflectedImage:(NSImage *)sourceNSImage density:(CGFloat)density fadeOut:(CGFloat)fadeOut direction:(NSUInteger) direction axisDistance:(CGFloat)axisDistance rotation:(CGFloat)rotationAngle flaps:(BOOL)flaps flapRotation:(CGFloat)flapRotation degression:(CGFloat)degression;
{
    NSBitmapImageRep *bmp = [NSBitmapImageRep imageRepWithData:[sourceNSImage TIFFRepresentation]];
    CIImage *sourceImage = [[[CIImage alloc] initWithBitmapImageRep:bmp] autorelease];
    CIImage *gradientImage;
    CIImage *toMove = nil;
    
    if(flaps)
        {
            sourceImage = [self rotatedImageFrom:sourceImage rotation:(CGFloat) flapRotation horizontal: (!(direction > WLReflectionBelow)) degression:degression];

        }


    CGRect rect = [sourceImage extent];

    CIFilter *canFilter = [CIFilter filterWithName:@"CILinearGradient"];
    CIFilter *transFilter = [CIFilter filterWithName:@"CIAffineTransform"];
    CIFilter *cropFilter = [CIFilter filterWithName:@"CICrop"];
    
    CIColor *c1 = [[[CIColor alloc] initWithColor: [NSColor colorWithCalibratedWhite:1.0 alpha:density]] autorelease];
    CIColor *c2 = [[[CIColor alloc] initWithColor: [NSColor clearColor]] autorelease];
 
    CIVector *p1 = [CIVector vectorWithX:0.0 Y:0.0];
    CIVector *p2;
    CGFloat scaleX = 1.0;
    CGFloat scaleY = 1.0;
    CGFloat deltaX = 0.0;
    CGFloat deltaY = 0.0;

    NSAffineTransform *trans = [NSAffineTransform transform];

    // set up the transformation to reflect the image
    if(direction > WLReflectionBelow)
        {// horizontal
            p2 = [CIVector vectorWithX:rect.size.width * fadeOut Y:0.0];

            scaleX = -1.0;
            deltaX = -rect.size.width;
            deltaY = 0.0;

        }
    else
        {// vertical
            p2 = [CIVector vectorWithX:0.0 Y:rect.size.height * fadeOut];
            scaleY = -1.0;
            deltaY = -rect.size.height;
            deltaX = 0.0;
        }
    
    [trans scaleXBy:scaleX yBy:scaleY];
    // move the reflected image into the opposite direction
    [trans translateXBy:deltaX yBy:deltaY];

    [transFilter setValue:trans forKey:@"inputTransform"];
    [transFilter setValue:sourceImage forKey:@"inputImage"];
    // first reflected image
    CIImage *reflectedImage = [transFilter valueForKey:@"outputImage"];

    [canFilter setValue:c1 forKey:@"inputColor0"];
    [canFilter setValue:c2 forKey:@"inputColor1"];
    [canFilter setValue:p1 forKey:@"inputPoint0"];
    [canFilter setValue:p2 forKey:@"inputPoint1"];
    
//This is the gradient image
    gradientImage =[canFilter valueForKey:@"outputImage"];
    
    [cropFilter setValue:[CIVector vectorWithX:0.0f Y:0.0f Z:rect.size.width W:rect.size.height]  forKey:@"inputRectangle"];
    [cropFilter setValue:gradientImage forKey:@"inputImage"];
//Cropped gradient image
    gradientImage =[cropFilter valueForKey:@"outputImage"];
    
    // revert the gradient mask for bottom and left reflection
    // There were problems transforming the image with negative coordinates, like unexpected cropping
    // first step:apply the axisDistance, and set the move distance (delta) for the transformation

    axisDistance += 1.0;
    if(direction > WLReflectionBelow)
        {
            deltaX = rect.size.width * axisDistance;
            deltaY = 0.0;
        }
    else
        {
            deltaY = rect.size.height * axisDistance;;
            deltaX = 0.0;
        }
    
    // Now, with both images still having the same coordinates, only transforms into positive coordinate
    // space are executed. Therefor a "toMove" image is created.
    if(direction == WLReflectionAbove || direction == WLReflectionRight)
        {// mirror the gradient image, if necessary
            [transFilter setValue:gradientImage forKey:@"inputImage"];
            gradientImage =[transFilter valueForKey:@"outputImage"];
            toMove = sourceImage;
        }

     // compose reflected image
    canFilter = [CIFilter filterWithName:@"CISourceAtopCompositing"];
    [canFilter setValue:reflectedImage forKey:@"inputImage"];
    [canFilter setValue:gradientImage forKey:@"inputBackgroundImage"];
    reflectedImage = [canFilter valueForKey:@"outputImage"];

//    rect = [reflectedImage extent];
//    NSLog(@"reflectedImage: %3.1f, %3.1f, %3.1f, %3.1f",rect.origin.x, rect.origin.y, rect.size.width, rect.size.height);
    
//    rect = [sourceImage extent];
//    NSLog(@"sourceImage: %3.1f, %3.1f, %3.1f, %3.1f;  %3.1f, %3.1f",rect.origin.x, rect.origin.y, rect.size.width, rect.size.height,deltaX,deltaY);
    
    // set up 2 transformations for source or reflected image
    // first set the source image to the one not to be moved
    sourceImage = toMove?reflectedImage:sourceImage;
    
    trans = [NSAffineTransform transform];
    [trans translateXBy:deltaX yBy:deltaY];
    [transFilter setValue:trans forKey:@"inputTransform"];

    [transFilter setValue:(toMove?toMove:reflectedImage) forKey:@"inputImage"];
    reflectedImage = [transFilter valueForKey:@"outputImage"];
//    rect = [reflectedImage extent];
//    NSLog(@"first transformed im: %3.1f, %3.1f, %3.1f, %3.1f",rect.origin.x, rect.origin.y, rect.size.width, rect.size.height);

// final composing of source and reflected image
    canFilter = [CIFilter filterWithName:@"CISourceOverCompositing"];
    [canFilter setValue:sourceImage forKey:@"inputBackgroundImage"];
    [canFilter setValue:reflectedImage forKey:@"inputImage"];
    
	if(rotationAngle)
		reflectedImage = [self rotatedImageFrom:[canFilter valueForKey:@"outputImage"] rotation:rotationAngle horizontal: (direction > WLReflectionBelow) degression:degression];
	else
		reflectedImage = [canFilter valueForKey:@"outputImage"];
	
    NSImage *resultImage = [NSImage imageFromCIImage: reflectedImage];
 
    return resultImage;
}


+ (CIImage *)rotatedImageFrom:(CIImage *)sourceImage rotation:(CGFloat) rotation horizontal:(BOOL) isHorz degression:(CGFloat)degression{
    CGRect rect = [sourceImage extent];
    CGFloat piRotation = rotation * PI/2;

    CGFloat deltaShorten = sin(piRotation);
//    CGFloat deltaEdge = cos(piRotation);
    CGFloat deltaEdge = 1.0 - cos(piRotation) * degression;
//     deltaEdge = deltaEdge>0.0 ? 1.0 - cos(rotation) *0.3 :  1.0 + cos(rotation) *0.3;
    
    CIFilter *transFilter = [CIFilter filterWithName:@"CIPerspectiveTransform"];
    CGFloat staticLeftX = rect.origin.x;
    CGFloat transformedLeftX = (rect.origin.x +(rect.size.width *(1.0-deltaEdge)));
    CGFloat staticRightX = rect.size.width;
    CGFloat transformedRightX = rect.size.width*deltaEdge ;

    CGFloat staticBottomY = rect.origin.y;
    CGFloat transformedBottomY = (rect.origin.y +(rect.size.height *(1.0-deltaEdge)));
    CGFloat staticTopY = rect.size.height;
    CGFloat transformedTopY = rect.size.height*deltaEdge ;
    
    
    CGFloat topLeftX, topLeftY;
    CGFloat topRightX, topRightY;
    CGFloat bottomLeftX, bottomLeftY;
    CGFloat bottomRightX, bottomRightY;
    CGFloat delta = 0.0;
    
    
    if(isHorz)
        {
            if(transformedLeftX < 0.0) delta = -transformedLeftX;

            topLeftX = staticLeftX + delta;
            bottomLeftX = transformedLeftX + delta;
            bottomRightX = transformedRightX + delta;
            topRightX = staticRightX + delta;
            bottomLeftY = bottomRightY = rect.origin.y;
            topLeftY = topRightY =  rect.size.height * deltaShorten;
        }
    else
        {
            if(transformedBottomY < 0.0) delta = -transformedBottomY;
            topLeftY = staticTopY + delta;
            bottomLeftY = staticBottomY + delta;
            bottomRightY = transformedBottomY + delta;
            topRightY = transformedTopY + delta;
            topRightX = bottomRightX = rect.size.width * deltaShorten;
            topLeftX = bottomLeftX = rect.origin.x;
        }
    
    CIVector *topLeft =         [CIVector vectorWithX: topLeftX     Y: topLeftY];
    CIVector *topRight =        [CIVector vectorWithX: topRightX    Y: topRightY];
    CIVector *bottomLeft =      [CIVector vectorWithX: bottomLeftX  Y: bottomLeftY];
    CIVector *bottomRight =     [CIVector vectorWithX:bottomRightX   Y: bottomRightY];

    
    [transFilter setValue:sourceImage forKey:@"inputImage"];
    [transFilter setValue:topLeft forKey:@"inputTopLeft"];
    [transFilter setValue:topRight forKey:@"inputTopRight"];
    [transFilter setValue:bottomRight forKey:@"inputBottomRight"];
    [transFilter setValue:bottomLeft forKey:@"inputBottomLeft"];

 //       rect = [[transFilter valueForKey:@"outputImage"] extent];
 //   NSLog(@"sourceImage: %3.1f, %3.1f, %3.1f, %3.1f;  %3.4f, %3.4f ( %3.1f, %3.1f, %3.1f, %3.1f)", rect.origin.x, rect.origin.y, rect.size.width, rect.size.height,deltaShorten,deltaEdge,topLeftX, topRightX, bottomLeftX, bottomRightX);

    return [transFilter valueForKey:@"outputImage"];
}

- (NSImage *)reflectedImageWithDensity:(CGFloat)density fadeOut:(CGFloat)fadeOut direction:(NSUInteger) direction axisDistance:(CGFloat)axisDistance rotation:(CGFloat)rotationAngle flaps:(BOOL)flaps flapRotation:(CGFloat)flapRotation degression:(CGFloat)degression;
{
    return [[self class] reflectedImage:self density:density fadeOut:fadeOut direction: direction axisDistance:axisDistance rotation:rotationAngle flaps:flaps flapRotation:flapRotation degression: degression];

}


+ (NSImage *)maskImageFromImageWithAlpha:(NSImage *)alphaImage
{
    if(alphaImage != nil && [alphaImage isKindOfClass:[NSImage class]])
        {
            NSBitmapImageRep *bm = [NSBitmapImageRep imageRepWithData:[alphaImage TIFFRepresentation]];
            if([bm hasAlpha])
                {
                    CIImage *ciImage = [[[CIImage alloc] initWithBitmapImageRep:bm]autorelease];
                    CIImage *result;
                    
                    CIFilterGenerator	*generator = [[CIFilterGenerator filterGenerator] retain];;
                    static CIFilter			*generatedFilter;
                    
                    
 //                   CIFilter *matrixFilter = [CIFilter filterWithName:@"CIColorMatrix"];
                    // all values are set to the same vector
                    CIVector    *alphaVector = [CIVector vectorWithX:0.0 Y:0.0 Z:0.0 W:1.0];
                    CIFilter *matrixFilter = [CIFilter filterWithName:@"CIColorMatrix"
                                                        keysAndValues:@"inputRVector",alphaVector,
                                                                      @"inputGVector",alphaVector,
                                                                      @"inputBVector",alphaVector,
                                                                      @"inputAVector",alphaVector,
                                                                      @"inputBiasVector",alphaVector,nil];

					
                    [generator connectObject:nil withKey:kCIInputImageKey toObject:matrixFilter withKey:kCIInputImageKey];
                    [generator exportKey:kCIInputImageKey fromObject:matrixFilter withName:nil];
                    
//                    [generator connectObject:matrixFilter withKey:kCIOutputImageKey toObject:nil withKey:kCIOutputImageKey];
                    [generator exportKey:kCIOutputImageKey fromObject:matrixFilter withName:nil];
                    generatedFilter = [generator filter];

                    [generatedFilter setValue:ciImage forKey:kCIInputImageKey];
                    result = [generatedFilter valueForKey:kCIOutputImageKey];

                    
                    // create an NSImage from the CIIamge, a triple step dance
                    NSCIImageRep *ciRep = [NSCIImageRep imageRepWithCIImage:result];
                    NSImage *image = [[NSImage alloc] initWithSize: [alphaImage size]];
                    [image addRepresentation:ciRep];

                    // and return it
                    return [image autorelease];
                    
                }
        }
return nil;
}


+ (NSImage*)provideBadgedImageFromImage:(NSImage*)backgroundImage andBadge:(NSImage*)badgeImage
{// Incomplete, presumed image size is 128.0 X 128.0
	// This is not an all purpose method but rather a draft for single purpose badged images
	// If you badge an image, you usually know where the image goes, and the dimensions of all images
	// Therefor you use a fixed transformation
	
	NSAffineTransform *transform = [NSAffineTransform transform];
	[transform translateXBy: 0.0 yBy:128.0];				// moves the badge on the background image
	[backgroundImage setScalesWhenResized:YES];				// don't use this line, if you apply a  Lanczos Scale Transform
	[backgroundImage setSize:NSMakeSize(128.0,128.0)];		// don't use this line, if you apply a  Lanczos Scale Transform


    NSBitmapImageRep *bmp = [NSBitmapImageRep imageRepWithData:[badgeImage TIFFRepresentation]];
	CIImage *badgeCIImage = [[[CIImage alloc] initWithBitmapImageRep:bmp] autorelease];
	CIImage *bgrdCIImage = [[[CIImage alloc] initWithBitmapImageRep:[NSBitmapImageRep imageRepWithData:[backgroundImage TIFFRepresentation]]] autorelease];
	CIImage *result;
	CIFilter *filter;

/*
	//	Use this, if you want to scale by a  Lanczos Scale Transform
	float scale = badgeImage.width/backgroundImage.width;
	filter = [CIFilter filterWithName:@"CILanczosScaleTransform"];	
			[filter setValue: badgeCIImage forKey:@"inputImage"];
			[filter setValue: [NSNumber numberWithFloat:scale] forKey:@"inputScale"];
			[filter setValue: [NSNumber numberWithFloat:1.0] forKey:@"inputAspectRatio"];
			badgeCIImage = [filter valueForKey:@"outputImage"];
*/	
	
	filter = [CIFilter filterWithName:@"CIAffineTransform"];
			[filter setValue: badgeCIImage forKey:@"inputImage"];
			[filter setValue: transform forKey:@"inputTransform"];
			result = [filter valueForKey:@"outputImage"];

		filter = [CIFilter filterWithName:@"CIGaussianBlur"];
			[filter setValue:bgrdCIImage forKey:@"inputImage"];
			[filter setValue:[NSNumber numberWithFloat:1.1] forKey:@"inputRadius"];
			bgrdCIImage = [filter valueForKey:@"outputImage"];

 		filter = [CIFilter filterWithName:@"CISourceOverCompositing"];
			[filter setValue:bgrdCIImage forKey:@"inputBackgroundImage"];
			[filter setValue:result forKey:@"inputImage"];
			result = [filter valueForKey:@"outputImage"];

   NSCIImageRep *ir = [NSCIImageRep imageRepWithCIImage:result];
	    CGRect rect = [result extent];
 
	NSImage *image = [[NSImage alloc] initWithSize:  NSMakeSize(rect.size.width, rect.size.height)];
    [image addRepresentation:ir];
	[image setScalesWhenResized:YES];
//	[image setSize:NSMakeSize(64.0,64.0)];

	return [image autorelease];
}



@end
