//
//  NSImage_ReflectionAdditions.h
//  MirrorImages
//
//  Created by Werner Lonsing on 2/29/08.
//  Copyright 2008 W. Lonsing. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#define WLReflectionAbove   1
#define WLReflectionBelow   2
#define WLReflectionLeft    3
#define WLReflectionRight   4

#define PI 3.14159265358979323846

@interface NSImage (ReflectionAdditions) 

+ (NSImage *)reflectedImage:(NSImage *)sourceNSImage density:(CGFloat)density fadeOut:(CGFloat)fadeOut direction:(NSUInteger) direction axisDistance:(CGFloat)axisDistance rotation:(CGFloat)rotationAngle flaps:(BOOL)flaps flapRotation:(CGFloat)flapRotation degression:(CGFloat)degression;
+ (CIImage *)rotatedImageFrom:(CIImage *)sourceImage rotation:(CGFloat) rotation horizontal:(BOOL) isHorz degression:(CGFloat)degression;
- (NSImage *)reflectedImageWithDensity:(CGFloat)density fadeOut:(CGFloat)fadeOut direction:(NSUInteger) direction axisDistance:(CGFloat)axisDistance rotation:(CGFloat)rotationAngle flaps:(BOOL)flaps flapRotation:(CGFloat)flapRotation degression:(CGFloat)degression;;

+ (NSImage *)maskImageFromImageWithAlpha:(NSImage *)alphaImage;
+ (NSImage*)provideBadgedImageFromImage:(NSImage*)backgroundImage andBadge:(NSImage*)badgeImage;

@end
