//
//  NSAffineTransform_Shearing.m
//  MirrorImages
//
//  Created by Werner Lonsing on 3/3/08.
//  Copyright 2008 W. Lonsing. All rights reserved.
//

#import "NSAffineTransform_Shearing.h"



@implementation NSAffineTransform (Shearing)

- (void) shearXBy: (CGFloat) xShear yBy: (CGFloat) yShear;
{
    NSAffineTransform *shearTransform = [[NSAffineTransform alloc] init];
    
    NSAffineTransformStruct 
    transformStruct = [shearTransform transformStruct];
    
    transformStruct.m21 = xShear;
    transformStruct.m12 = yShear;
    
    [shearTransform setTransformStruct:transformStruct];
    [self appendTransform:shearTransform];
    [shearTransform release];
}


- (void) shearXBy:(CGFloat) xShear { [self shearXBy:xShear yBy:0.0];  }
- (void) shearYBy:(CGFloat) yShear  {  [self shearXBy:0.0 yBy:yShear]; }

@end
