//
//  EditViewController.m
//  SQLiteExample
//
//  Created by Jonathan Diehl on 24.06.08.
//  Copyright 2008 Media Computing Group. All rights reserved.
//

#import "EditViewController.h"


@implementation EditViewController

@synthesize item;

// constructor
- (id)initWithItem:(Item *)newItem;
{
	if (self = [super initWithNibName:@"EditView" bundle:nil]) {
		[self setItem:newItem];
		[self setTitle:[[self item] name]];
	}
	return self;
}

// constructor for creating a new item
- (id)initWithNewItem;
{
	Item *newItem = [[Item alloc] init];
	self = [self initWithItem:newItem];
	[self setTitle:@"New Item"];
	return self;
}

// show name in text field
- (void)viewDidLoad {
	[textField setText:[[self item] name]];
}

// update name in record
- (void)textFieldDidEndEditing:(UITextField *)tField;
{
	[item setName:[tField text]];
	[item save];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
	// Return YES for supported orientations
	return (interfaceOrientation == UIInterfaceOrientationPortrait);
}


- (void)didReceiveMemoryWarning {
	[super didReceiveMemoryWarning]; // Releases the view if it doesn't have a superview
	// Release anything that's not essential, such as cached data
}


- (void)dealloc {
	[super dealloc];
}


@end
