//
//  SQLiteStatement.m
//  APDA
//
//  Created by Jonathan Diehl on 12.05.08.
//  Copyright 2008 Media Computing Group. All rights reserved.
//

#import "SQLiteStatement.h"

@interface NSObject (SQLLiteConnection);
- (sqlite3_stmt *)prepareQuery:(NSString *)query;
@end

@implementation SQLiteStatement

- (void)prepare;
{
	statement = [connection prepareQuery:query];
	
}
- (BOOL)next;
{
	return(sqlite3_step(statement) == SQLITE_ROW);
}

- (void)finalize;
{
	sqlite3_finalize(statement);
}

- (int)intValueForIndex:(int)index;
{
	return sqlite3_column_int(statement, index);
}

- (NSString *)stringValueForIndex:(int)index;
{
	const char* text = (char*)sqlite3_column_text(statement, index);
	return [NSString stringWithUTF8String:text];
}

@end
