//
//  DatabaseConnection.h
//  APDA
//
//  Created by Jonathan Diehl on 12.05.08.
//  Copyright 2008 Media Computing Group. All rights reserved.
//

#import "DatabaseStatement.h"

@interface DatabaseConnection : NSObject {
	NSString *databaseName;
}

// singleton accessor
+ (DatabaseConnection *)connection;
+ (void)setConnection:(DatabaseConnection *)newConnection;

// database controls
- (void) open;
- (void) close;

// query escaping
- (NSString *)escapeString:(NSString *)string;

// query execution
- (DatabaseStatement *)selectQuery:(NSString *)query;
- (void)updateQuery:(NSString *)query;

@end
