//
//  RootViewController.m
//  SQLiteExample
//
//  Created by Jonathan Diehl on 24.06.08.
//  Copyright Media Computing Group 2008. All rights reserved.
//

#import "RootViewController.h"
#import "SQLiteExampleAppDelegate.h"
#import "Item.h"
#import "EditViewController.h"

@implementation RootViewController


- (void)viewDidLoad {
	// load items
	items = [[NSMutableArray arrayWithArray:[Item findAll]] retain];
	
	// set title
	[self setTitle:@"Items"];
	
	// make editable
	self.navigationItem.leftBarButtonItem = self.editButtonItem;
	
	// allow adding
	UIBarButtonItem *addButton = [[UIBarButtonItem alloc] initWithTitle:@"Add" 
																  style:UIBarButtonItemStylePlain 
																 target:self 
																 action:@selector(didSelectAdd:)];
	self.navigationItem.rightBarButtonItem = addButton;
}

// number of sections
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
	return 1;
}

// number of rows
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
	return [items count];
}

// cell for an index
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
	// get the cell from the active record
	Item *item = [items objectAtIndex:[indexPath row]];
	return [item cellForTableView:tableView];
}

// on selection of a cell
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
	Item *item = [items objectAtIndex:[indexPath row]];
	EditViewController *viewController = [[EditViewController alloc] initWithItem:item];
	[[self navigationController] pushViewController:viewController animated:YES];
	[viewController release];
}

// edit support
- (void)tableView:(UITableView *)tableView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath {
		
	if (editingStyle == UITableViewCellEditingStyleDelete) {
		// Delete the row from the data source
		[tableView deleteRowsAtIndexPaths:[NSArray arrayWithObject:indexPath] withRowAnimation:YES];
		Item *item = [items objectAtIndex:[indexPath row]];
		[item destroy];
		[items removeObjectAtIndex:[indexPath row]];
	}	
}
								  
// add support
- (void)didSelectAdd:(UIBarButtonItem *)addButton;
{
	EditViewController *viewController = [[EditViewController alloc] initWithNewItem];
	[[self navigationController] pushViewController:viewController animated:YES];
	[viewController release];
}

/*
 Override if you support conditional editing of the list
- (BOOL)tableView:(UITableView *)tableView canEditRowAtIndexPath:(NSIndexPath *)indexPath {
	// Return NO if you do not want the specified item to be editable.
	return YES;
}
*/


/*
 Override if you support rearranging the list
- (void)tableView:(UITableView *)tableView moveRowAtIndexPath:(NSIndexPath *)fromIndexPath toIndexPath:(NSIndexPath *)toIndexPath {
}
*/


/*
 Override if you support conditional rearranging of the list
- (BOOL)tableView:(UITableView *)tableView canMoveRowAtIndexPath:(NSIndexPath *)indexPath {
	// Return NO if you do not want the item to be re-orderable.
	return YES;
}
 */ 


- (void)viewWillAppear:(BOOL)animated {
	[super viewWillAppear:animated];
}

- (void)viewDidAppear:(BOOL)animated {
	[super viewDidAppear:animated];
}

- (void)viewWillDisappear:(BOOL)animated {
}

- (void)viewDidDisappear:(BOOL)animated {
}


- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
	// Return YES for supported orientations
	return (interfaceOrientation == UIInterfaceOrientationPortrait);
}


- (void)didReceiveMemoryWarning {
	[super didReceiveMemoryWarning]; // Releases the view if it doesn't have a superview
	// Release anything that's not essential, such as cached data
}


- (void)dealloc {
	[items release];
	[super dealloc];
}


@end

