//
//  ActiveRecord.h
//  APDA
//
//  Created by Jonathan Diehl on 12.05.08.
//  Copyright 2008 Media Computing Group. All rights reserved.
//

#import "DatabaseConnection.h"
#import "DatabaseStatement.h"

@interface ActiveRecord : NSObject {
	int idValue;
}

@property(assign) int idValue;

// static connection property
+ (DatabaseConnection *)connection;

// table and columns info
+ (NSString *)tableName;

// find methods
+ (NSArray *)findBySQL:(NSString *)query;
+ (NSArray *)findAll;
+ (ActiveRecord *)findById:(int)idValue;

// constructor
- (id)initWithStatement:(DatabaseStatement *)statement;

// convenience methods
- (NSString *)tableName;
- (DatabaseConnection *)connection;

// save (or create)
- (void)save;
- (void)destroy;
- (NSString *)insertQuery;
- (NSString *)updateQuery;
- (NSString *)deleteQuery;

// table view cell methods
- (NSString *)tableViewCellIdentifier;
- (UITableViewCell *)tableViewCell;
- (void)updateTableViewCell:(UITableViewCell *)tableViewCell;
- (UITableViewCell *)cellForTableView:(UITableView *)tableView;

@end
