//
//  RootViewController.m
//  Barcode
//
//  Created by Stefan Hafeneger on 28.05.08.
//  Copyright 2008 CocoaHeads Aachen. All rights reserved.
//

#import "SHRootViewController.h"

#import "BarcodeAppDelegate.h"

@implementation SHRootViewController

#pragma mark Allocation

- (id)init {
	self = [super initWithStyle:UITableViewStyleGrouped];
	if(self != nil) {
		self.title = @"Barcode Reader";
	}
	return self;
}

- (void)dealloc {
	[super dealloc];
}

#pragma mark <UITableViewDelegate>

- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
	
	// Create table view cell.
	static NSString *MyIdentifier = @"MyIdentifier";
	UITableViewCell *tableViewCell = [tableView dequeueReusableCellWithIdentifier:MyIdentifier];
	if(tableViewCell == nil)
		tableViewCell = [[[UITableViewCell alloc] initWithFrame:CGRectZero reuseIdentifier:MyIdentifier] autorelease];
	
	// Configure the table view cell.
	tableViewCell.text = @"DataMatrix";
	
	return tableViewCell;
}

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
	// Unhighlight table view item.
	[tableView deselectRowAtIndexPath:indexPath animated:YES];
	// Begin magic stuff.
	BarcodeAppDelegate *applicationDelegate = (BarcodeAppDelegate *)[UIApplication sharedApplication].delegate;
	[applicationDelegate decodeDataMatrixBarcode];
}

#pragma mark <UITableViewDataSource>

- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
	// There is just one item in the table view.
	return 1;
}

@end
