//
//  BarcodeAppDelegate.m
//  Barcode
//
//  Created by Stefan Hafeneger on 28.05.08.
//  Copyright CocoaHeads Aachen 2008. All rights reserved.
//

#import "BarcodeAppDelegate.h"

#import "SHRootViewController.h"
#import "SHDataMatrixReader.h"

@implementation BarcodeAppDelegate

@synthesize window, navigationController = _navigationController;

#pragma mark Allocation

- (void)applicationDidFinishLaunching:(UIApplication *)application {	
	
	// Create root view controller.
	SHRootViewController *rootViewController = [[SHRootViewController alloc] init];
	
	// Create navigation controller.
	UINavigationController *navigationController = [[UINavigationController alloc] initWithRootViewController:rootViewController];
	self.navigationController = navigationController;
	[navigationController release];
	[rootViewController release];
	
	// Configure and show the window.
	[window addSubview:navigationController.view];
	[window makeKeyAndVisible];
	
}

- (void)dealloc {
	
	[window release];
	[self.navigationController release];
	[super dealloc];
	
}

#pragma mark Instance

- (void)decodeDataMatrixBarcode {
	
#if TARGET_IPHONE_SIMULATOR
	// There is no camera available in the simulator.
	UIImage *image = [UIImage imageNamed:@"SimulatorBarcode.png"];
	[self imagePickerController:nil didFinishPickingImage:image editingInfo:nil];
#else
	// Camera is only available on the iPhone.
	if([UIImagePickerController isSourceTypeAvailable:UIImagePickerControllerSourceTypeCamera]) {
		// Create new image picker controller.
		UIImagePickerController *imagePickerController = [[UIImagePickerController alloc] init];
		imagePickerController.sourceType = UIImagePickerControllerSourceTypeCamera;
		imagePickerController.allowsImageEditing = NO;
		imagePickerController.delegate = self;
		// Show the image picker.
		[self.navigationController presentModalViewController:imagePickerController animated:YES];
	} else {
		[self showAlertWithTitle:@"Error" message:@"This function needs a camera which is only available on the iPhone."];
	}
#endif
	
}

- (void)showAlertWithTitle:(NSString *)title message:(NSString *)message {
	
	UIAlertView *alertView = [[UIAlertView alloc] initWithTitle:title message:message delegate:nil cancelButtonTitle:@"OK" otherButtonTitles:nil];
	[alertView show];
	[alertView release];
	
}

#pragma mark <UIImagePickerControllerDelegate>

- (void)imagePickerController:(UIImagePickerController *)imagePickerController didFinishPickingImage:(UIImage *)image editingInfo:(NSDictionary *)editingInfo {

#if TARGET_IPHONE_SIMULATOR
#else
	// Dismiss image picker.
	[self.navigationController dismissModalViewControllerAnimated:YES];
#endif
	// Decode barcode image.
	NSString *string = [[SHDataMatrixReader sharedDataMatrixReader] decodeBarcodeFromImage:image];
	// Show result.
	if(string == nil) {
		[self showAlertWithTitle:@"Error" message:@"Could not decode DataMatrix barcode from image."];
	} else {
		[self showAlertWithTitle:@"Result" message:string];
	}
	
}

- (void)imagePickerControllerDidCancel:(UIImagePickerController *)imagePickerController {
	
	// Dismiss image picker.
	[self.navigationController dismissModalViewControllerAnimated:YES];
	
}

#pragma mark UINavigationControllerDelegate

- (void)navigationController:(UINavigationController *)navigationController didShowViewController:(UIViewController *)viewController animated:(BOOL)animated {
	
}

- (void)navigationController:(UINavigationController *)navigationController willShowViewController:(UIViewController *)viewController animated:(BOOL)animated {
	
}

@end
