//
//  LoginViewController.swift
//  AuthenticationDemo
//
//  Created by Jonas Schlabertz on 18.06.19.
//  Copyright © 2019 Jonas Schlabertz. All rights reserved.
//

import UIKit
import AuthenticationServices
import SnapKit

class LoginViewController: UIViewController {
  
    override func viewDidLoad() {
        self.view.backgroundColor = .systemBackground
        
        let loginButton = ASAuthorizationAppleIDButton(type: .default, style: .whiteOutline)
        loginButton.addTarget(self, action: #selector(login(_:)), for: .touchUpInside)
        
        self.view.addSubview(loginButton)
        
        loginButton.snp.makeConstraints { (make) in
            make.center.equalToSuperview()
        }
        
    }
    
    @objc func login(_ target: UIButton) {
        let appleIDProvider = ASAuthorizationAppleIDProvider()
        let request = appleIDProvider.createRequest()
        request.requestedScopes = [.fullName, .email]
        
        let authorizationController = ASAuthorizationController(authorizationRequests: [request])
        
        // This is not required in all setups
        authorizationController.presentationContextProvider = self
        
        authorizationController.delegate = self
        authorizationController.performRequests()
    }
    
}

extension LoginViewController: ASAuthorizationControllerDelegate {
    
    func authorizationController(controller: ASAuthorizationController, didCompleteWithAuthorization authorization: ASAuthorization) {
        guard let credentials = authorization.credential as? ASAuthorizationAppleIDCredential else {
            print("Could not cast credentials to ASAuthorizationAppleIDCredential.")
            return
        }
        
        print(String(reflecting: credentials))
    }
    
    func authorizationController(controller: ASAuthorizationController, didCompleteWithError error: Error) {
        guard let authError = error as? ASAuthorizationError else {
            print(error.localizedDescription)
            return
        }
        
        print(authError.localizedDescription)
    }
    
}

extension LoginViewController: ASAuthorizationControllerPresentationContextProviding {
    
    func presentationAnchor(for controller: ASAuthorizationController) -> ASPresentationAnchor {
        return UIApplication.shared.windows.first!
    }
    
}
