//
//  ASAuthorizationAppleIDCredential+CustomDebugStringConvertible.swift
//  AuthenticationDemo
//
//  Created by Jonas Schlabertz on 27.08.19.
//  Copyright © 2019 Jonas Schlabertz. All rights reserved.
//

import AuthenticationServices

extension ASAuthorizationAppleIDCredential: CustomDebugStringConvertible {
    override open var debugDescription: String {
        return """
        identity token: \(String(data: self.identityToken ?? Data(), encoding: .utf8))
        authorization code: \(String(data: self.authorizationCode ?? Data(), encoding: .utf8))
        state: \(self.state)
        user: \(self.user)
        auth scopes: \(self.authorizedScopes)
        name: \(self.fullName)
        email: \(self.email)
        real user status: \(self.realUserStatus)
        """
    }
}

