# Sign in With Apple

## App

The app container boilerplate code to initiate a login and get the login results. The login results are printed, so make sure to connect with the debugger to get the login results.

## Verifying Identity Tokens

The identity token is just a JSON Web Token signed by apple. The token can be verified against Apple's public key which can be fetched at the URL https://appleid.apple.com/auth/keys

## Secret Generator

The secret generator is a script which can generate the client secret used in the verification process of the authorization code. To run this script, you first need to install Node.js and install the script's dependencies by running `npm install`. 

Generate your private key in the [developer portal](https://developer.apple.com/account/resources/authkeys/list). Place the key in the same directory as the secret generator and rename the keyfile to `key.p8`. Open the `index.js` file and fill in your application ID, team ID and key ID. The current version will set the client secret to expire after one day. This can be increased to up to six months. 

You can run the script by executing `npm start`. The client secret will be printed to the terminal.

## Verifying the authentication code

To verify the key, the command below can be used. Just fill in your App ID, the client secret and the authorization code which is obtained through signing in with the app.

```
curl -X "POST" "https://appleid.apple.com/auth/token" \
     -H 'Content-Type: application/x-www-form-urlencoded; charset=utf-8' \
     --data-urlencode "client_id=<APP ID>" \
     --data-urlencode "grant_type=authorization_code" \
     --data-urlencode "client_secret=<CLIENT SECRET>" \
     --data-urlencode "code=<AUTH CODE>"
```

The response will contain a JSON Web Token which includes the user information.

## Debugging JSON Web Tokens

The homepage of JWT has a debugger which can be used to play around with JSON Web Tokens. On this homepage you can also find JWT libraries for all kinds of programming languages.

https://jwt.io

## Paw file

The request to verify the authentication code is also included as a pawfile. This can be opened using the [Paw](https://paw.cloud/) app.