//
//  ViewController.swift
//  iPodAccess
//
//  Created by Jan-Peter Krämer on 30/12/15.
//  Copyright © 2015 RWTH Aachen University. All rights reserved.
//

import UIKit
import MediaPlayer

class ViewController: UIViewController {

	override func viewDidLoad() {
		super.viewDidLoad()
		// Do any additional setup after loading the view, typically from a nib.
	}
	
	override func viewDidAppear(animated: Bool) {
//		let player = MPMusicPlayerController.applicationMusicPlayer()
//		
//		player.setQueueWithQuery(MPMediaQuery.songsQuery())
//		
//		player.play()
	}
	
	@IBAction func pickTracks(sender: AnyObject) {
		let picker = MPMediaPickerController(mediaTypes: .Music)
		picker.allowsPickingMultipleItems = true
		picker.delegate = self
		self.presentViewController(picker, animated: true, completion: nil)
	}

	override func didReceiveMemoryWarning() {
		super.didReceiveMemoryWarning()
		// Dispose of any resources that can be recreated.
	}
}

extension ViewController : MPMediaPickerControllerDelegate {
	func mediaPicker(mediaPicker: MPMediaPickerController, didPickMediaItems mediaItemCollection: MPMediaItemCollection) {
		self.dismissViewControllerAnimated(true, completion: nil)
		
		let player = MPMusicPlayerController.systemMusicPlayer()
		player.setQueueWithItemCollection(mediaItemCollection)
		
		player.play()
	}
}

