//
//  ViewController.swift
//  VideoEdit
//
//  Created by Jan-Peter Krämer on 31/12/15.
//  Copyright © 2015 RWTH Aachen University. All rights reserved.
//

import UIKit
import AVFoundation

class VideoSampleBufferSource : NSObject {
	lazy var displayLink: CADisplayLink = CADisplayLink(target: self, selector: "displayLinkDidRefresh:")
	
	let videoOutput: AVPlayerItemVideoOutput
	let consumer: CVPixelBuffer -> ()
	let player: AVPlayer
	
	init?(url: NSURL, consumer callback: CVPixelBuffer -> ()) {
		player = AVPlayer(URL: url)
		consumer = callback
		videoOutput = AVPlayerItemVideoOutput(pixelBufferAttributes: [:])
		player.currentItem?.addOutput(videoOutput)
		
		super.init()
		
		start()
		player.play()
	}
	
	func start() {
		displayLink.addToRunLoop(NSRunLoop.mainRunLoop(), forMode: NSRunLoopCommonModes)
	}
	
	func displayLinkDidRefresh(link: CADisplayLink) {
		let itemTime = videoOutput.itemTimeForHostTime(CACurrentMediaTime())
		if videoOutput.hasNewPixelBufferForItemTime(itemTime) {
			var presentationItemTime = kCMTimeZero
			let pixelBuffer = videoOutput.copyPixelBufferForItemTime(itemTime, itemTimeForDisplay: &presentationItemTime)!
			consumer(pixelBuffer)
		}
	}
}

class ViewController: UIViewController {

	var videoOutput: AVPlayerItemVideoOutput!

	var coreImageView: CoreImageView!
	var videoSampleBufferSource: VideoSampleBufferSource!
	
	override func viewDidLoad() {
		coreImageView = CoreImageView(frame: CGRect())
		self.view = coreImageView
	}
	
	override func viewDidAppear(animated: Bool) {
		let url = NSBundle.mainBundle().URLForResource("Cat", withExtension: "mp4")!
		
		videoSampleBufferSource = VideoSampleBufferSource(url: url) { (buffer) -> () in
			let input = CIImage(CVPixelBuffer: buffer)
			let filter = CIFilter(name: "CIColorControls")!
			let filter2 = CIFilter(name: "CIExposureAdjust")!
			
			filter.setValue(0.0, forKey: kCIInputBrightnessKey)
			filter.setValue(1.1, forKey: kCIInputContrastKey)
			filter.setValue(0.0, forKey: kCIInputSaturationKey)
			
			filter2.setValue(0.3, forKey: kCIInputEVKey)
			
			filter.setValue(input, forKey: kCIInputImageKey)
			filter2.setValue(filter.outputImage, forKey: kCIInputImageKey)
			
			self.coreImageView.image = filter2.outputImage
		}
		// Do any additional setup after loading the view, typically from a nib.
	}

	override func didReceiveMemoryWarning() {
		super.didReceiveMemoryWarning()
		// Dispose of any resources that can be recreated.
	}


}

