//
//  ViewController.swift
//  SimpleAVCam
//
//  Created by Jan-Peter Krämer on 29/12/15.
//  Copyright © 2015 RWTH Aachen University. All rights reserved.
//

import UIKit
import AVFoundation
import Photos

class ViewController: UIViewController {
	
	@IBOutlet weak var imageView: UIImageView!
	var sessionQueue: dispatch_queue_t!
	var session: AVCaptureSession!
	var stillImageOutput: AVCaptureStillImageOutput!
	var captureDevice: AVCaptureDevice!
	
	override func viewDidLoad() {
		super.viewDidLoad()
		
		session = AVCaptureSession()
		sessionQueue = dispatch_queue_create( "session queue", DISPATCH_QUEUE_SERIAL )
		
		switch (AVCaptureDevice.authorizationStatusForMediaType(AVMediaTypeVideo)) {
		case .NotDetermined:
			dispatch_suspend( self.sessionQueue );
			AVCaptureDevice.requestAccessForMediaType(AVMediaTypeVideo) { granted in
				if (!granted) {
					return
				}
				dispatch_resume( self.sessionQueue );
			}
			break
		case .Authorized:
			break
		default:
			return
		}
		
		dispatch_async(self.sessionQueue) {
			let videoDevices = AVCaptureDevice.devicesWithMediaType(AVMediaTypeVideo).filter() { element -> Bool in
				if let device = element as? AVCaptureDevice {
					return device.position == .Back
				}
				return false
			}
			
			if videoDevices.count < 1 {
				return
			}
			
			let captureDevice = videoDevices[0] as! AVCaptureDevice
			
			guard let captureDeviceInput = try? AVCaptureDeviceInput(device: captureDevice) else {
				print("Coult not create video device input")
				return
			}
			
			self.session.beginConfiguration()
			
			if (self.session.canAddInput(captureDeviceInput)) {
				self.session.addInput(captureDeviceInput)
				
				self.captureDevice = captureDevice
			}
			
			let stillImageOutput = AVCaptureStillImageOutput()
			if (self.session.canAddOutput(stillImageOutput)) {
				self.session.addOutput(stillImageOutput)
				self.stillImageOutput = stillImageOutput
				self.stillImageOutput.outputSettings = [ AVVideoCodecKey: AVVideoCodecJPEG ]
				self.stillImageOutput.highResolutionStillImageOutputEnabled = true
			}
			
			self.session.commitConfiguration()
			self.session.startRunning()
		}
	}

	override func didReceiveMemoryWarning() {
		super.didReceiveMemoryWarning()
		// Dispose of any resources that can be recreated.
	}

	@IBAction func snapImage(sender: AnyObject) {
		dispatch_async(self.sessionQueue) {
			self.stillImageOutput.captureStillImageAsynchronouslyFromConnection(self.stillImageOutput.connectionWithMediaType(AVMediaTypeVideo)) { (buffer, error) -> Void in
				if (error != nil) {
					print(error)
					return
				}
				
				let imageData = AVCaptureStillImageOutput.jpegStillImageNSDataRepresentation(buffer)
				dispatch_async(dispatch_get_main_queue()) {
					let image = UIImage(data: imageData)
					self.imageView.image = image
				}
//				PHPhotoLibrary.requestAuthorization() { status in
//					if (status == .Authorized) {
//						PHPhotoLibrary.sharedPhotoLibrary().performChanges(
//							{ () -> Void in
//								PHAssetCreationRequest.creationRequestForAsset().addResourceWithType(.FullSizePhoto, data: imageData, options: nil)
//							}, completionHandler: { (success, error) -> Void in
//								if (!success) {
//									print(error)
//							}
//						})
//					}
//				}
			}
		}
	}

}

