//
//  ViewController.swift
//  AudioPlayground
//
//  Created by Jan-Peter Krämer on 30/12/15.
//  Copyright © 2015 RWTH Aachen University. All rights reserved.
//

import UIKit
import AVFoundation
import AudioToolbox

class ViewController: UIViewController {
	var player: AVAudioPlayer!
	var systemSound: SystemSoundID = 0
	var recordURL: NSURL?
	var recorder: AVAudioRecorder?
	
	override func viewDidLoad() {
		super.viewDidLoad()
		
		let url = NSBundle.mainBundle().URLForResource("tap", withExtension: "aif")!
		AudioServicesCreateSystemSoundID(url, &systemSound)
		
		// Do any additional setup after loading the view, typically from a nib.
	}
	
	override func viewDidAppear(animated: Bool) {
		let url = NSBundle.mainBundle().URLForResource("sound", withExtension: "mp3")!
		player = try! AVAudioPlayer(contentsOfURL: url)
		player.prepareToPlay()
	}
	
	@IBAction func playPause(sender: AnyObject) {
		if (self.player.playing) {
			self.player.pause()
		} else {
			self.player.play()
		}
	}

	@IBAction func playSystemSound(sender: AnyObject) {
		AudioServicesPlaySystemSound(systemSound)
	}
	
	@IBAction func vibrate(sender: AnyObject) {
		AudioServicesPlaySystemSound(kSystemSoundID_Vibrate)
	}
	
	@IBAction func record(sender: AnyObject) {
		if (recorder == nil) {
			let path = NSTemporaryDirectory() + "sound.caf"
			recordURL = NSURL(fileURLWithPath: path)
			
			let session = AVAudioSession.sharedInstance()
			try! session.setCategory(AVAudioSessionCategoryPlayAndRecord)
			try! session.setActive(true)
			session.requestRecordPermission { (success) -> Void in
				if (!success) {
					return
				}
				if let existingURL = self.recordURL {
					let settings: [String:AnyObject] = [
						AVSampleRateKey: 44100.0,
						AVFormatIDKey: Int(kAudioFormatAppleLossless),
						AVNumberOfChannelsKey: 1,
						AVEncoderAudioQualityKey: AVAudioQuality.Max.rawValue
					]
					
					if let recorder = try? AVAudioRecorder(URL: existingURL, settings: settings) {
						self.recorder = recorder
						
						recorder.delegate = self
						recorder.prepareToRecord()
						recorder.record()
					}
				}
			}
		} else {
			self.recorder?.stop()
			self.recorder = nil
		}
	}
	
	@IBAction func playRecording(sender: AnyObject) {
		if let existingURL = self.recordURL {
			player = try! AVAudioPlayer(contentsOfURL: existingURL)
			player.prepareToPlay()
			player.play()
		}
	}
	
	override func didReceiveMemoryWarning() {
		super.didReceiveMemoryWarning()
		// Dispose of any resources that can be recreated.
	}
}

extension ViewController : AVAudioRecorderDelegate {
	
}

