//
//  ViewController.swift
//  CoreImagePlayground
//
//  Created by Jan-Peter Krämer on 31/12/15.
//  Copyright © 2015 RWTH Aachen University. All rights reserved.
//

import UIKit

class ViewController: UIViewController {

	@IBOutlet weak var imageView: UIImageView!
	
	override func viewDidLoad() {
		super.viewDidLoad()
		guard let image = imageView.image else {
			print ("no image")
			return
		}
		
		let eaglContext = EAGLContext(API: .OpenGLES2)
		let context = CIContext(EAGLContext: eaglContext)
		
		if let ciimage = CIImage(image: image),
			filter = CIFilter(name: "CIColorControls"),
			filter2 = CIFilter(name: "CIExposureAdjust")
		{
			filter.setValue(0.0, forKey: kCIInputBrightnessKey)
			filter.setValue(1.1, forKey: kCIInputContrastKey)
			filter.setValue(0.0, forKey: kCIInputSaturationKey)
			
			filter2.setValue(0.6, forKey: kCIInputEVKey)
			
			filter.setValue(ciimage, forKey: kCIInputImageKey)
			filter2.setValue(filter.outputImage, forKey: kCIInputImageKey)
			
			let result = filter2.valueForKey(kCIOutputImageKey) as! CIImage

			let cgimage = context.createCGImage(result, fromRect: result.extent)
			
			imageView.image = UIImage(CGImage: cgimage)
		}
		

		// Do any additional setup after loading the view, typically from a nib.
	}
	

	override func didReceiveMemoryWarning() {
		super.didReceiveMemoryWarning()
		// Dispose of any resources that can be recreated.
	}


}

