//
//  ViewController.swift
//  TouchDemo
//
//  Created by NurWork on 21/12/15.
//  Copyright © 2015 RWTH Aachen Univesity. All rights reserved.
//

import UIKit

class ViewController: UIViewController, UIGestureRecognizerDelegate {

    @IBOutlet weak var star:Star!
    
    override func viewDidLoad() {
        super.viewDidLoad()
       
         let recognizer = UIPanGestureRecognizer(target: self, action:"handlePan:")
        recognizer.delegate = self
        star.addGestureRecognizer(recognizer)
        
        let customRcognizer = CheckmarkGestureRecognizer(target: self, action:"handleCheckMark:")
        recognizer.delegate = self
        self.view.addGestureRecognizer(customRcognizer)
        

    }

    override func didReceiveMemoryWarning() {
        super.didReceiveMemoryWarning()
        // Dispose of any resources that can be recreated.
    }
    
    
    @IBAction func handlePan(recognizer:UIPanGestureRecognizer)
    {
        if let view = recognizer.view
        {
            switch(recognizer.state)
            {
            case .Began:
                break
                //do somthing: scale up
            case .Changed:
                let translation = recognizer.translationInView(self.view)
                view.center = CGPoint(x:view.center.x + translation.x,
                    y:view.center.y + translation.y)
                recognizer.setTranslation(CGPointZero, inView: self.view)
            case .Ended, .Cancelled:
                break
                //do something: scale down
            default:
                break
            }
        }
    }
    

    
    
    @IBAction func handlePinch(recognizer:UIPinchGestureRecognizer) {
        if let view = recognizer.view {
            view.transform = CGAffineTransformScale(view.transform,
                recognizer.scale, recognizer.scale)
            recognizer.scale = 1
        }
    }
    
    @IBAction func handleRotate(recognizer:UIRotationGestureRecognizer) {
        if let view = recognizer.view {
            view.transform = CGAffineTransformRotate(view.transform, recognizer.rotation)
            recognizer.rotation = 0
        }
    }
    
    
    
    //Must add this vc as a delegate for all simul. recognizers
    func gestureRecognizer(_: UIGestureRecognizer,
        shouldRecognizeSimultaneouslyWithGestureRecognizer:UIGestureRecognizer) -> Bool {
            return true //deafult false
    }
    
    
    
    
    
    
    func handleCheckMark(recognizer:CheckmarkGestureRecognizer)
    {
        UIView.animateWithDuration(0.7, delay: 0, options: .CurveLinear, animations: {
            recognizer.view!.backgroundColor = UIColor.blueColor()
            recognizer.view!.alpha = 0.8
            }, completion: {finished in
                recognizer.view!.backgroundColor = UIColor.whiteColor()
                recognizer.view!.alpha = 1.0})
    }

}

