//
//  CheckmarkGestureRecognizer.swift
//  TouchDemo
//
//  Created by NurWork on 21/12/15.
//  Copyright © 2015 RWTH Aachen Univesity. All rights reserved.
//

import Foundation
import UIKit

//New Objective-C File. Name the file Bridging-Header > Agree. Delete Bridging-Header.m. Add #import <UIKit/UIGestureRecognizerSubclass.h> to <ProjectName>-Bridging-Header.h:
class CheckmarkGestureRecognizer:UIGestureRecognizer {
    
    var strokeUp:Bool = false
    var midPoint:CGPoint = CGPointZero
    
    override func touchesBegan(touches: Set<UITouch>, withEvent event: UIEvent?) {
        if touches.count != 1 {
            self.state = .Failed
            return
        }
    }
    
    override func touchesMoved(touches: Set<UITouch>, withEvent event: UIEvent?) {
        if self.state == .Failed
        {
            return
        }
        
        if let touch = touches.first
        {
            //let win = self.view!.window
            //let nowPoint:CGPoint = touch.locationInView(win)
            let nowPoint:CGPoint = touch.locationInView(self.view)
            let prevPoint:CGPoint = touch.previousLocationInView(self.view)

            // strokeUp is a property
            if !self.strokeUp {
                // On downstroke, both x and y increase in positive direction
                if nowPoint.x >= prevPoint.x && nowPoint.y >= prevPoint.y
                {
                    self.midPoint = nowPoint;
                    // Upstroke has increasing x value but decreasing y value
                } else if nowPoint.x >= prevPoint.x && nowPoint.y <= prevPoint.y
                {
                    self.strokeUp = true
                } else
                {
                    self.state = .Failed
                }
            }
        }
    }

    override func touchesEnded(touches: Set<UITouch>, withEvent event: UIEvent?) {
        if self.state == .Possible && self.strokeUp
        {
            self.state = .Recognized;
        }
    }
    
    override func touchesCancelled(touches: Set<UITouch>, withEvent event: UIEvent?) {
        self.state = .Failed
    }
    
    override func reset() {
        super.reset()
        self.midPoint = CGPointZero
        self.strokeUp = false
        if self.state == .Possible {
            self.state = .Failed
        }
    }
}