//
//  ViewController.swift
//  CoreMotionApp
//
//  Created by NurWork on 20/12/15.
//  Copyright © 2015 RWTH Aachen Univesity. All rights reserved.
//

import UIKit
import CoreMotion

class ViewController: UIViewController {
    let manager = CMMotionManager()
    @IBOutlet weak var imageView:UIImageView!
    let images = ["box0", "box1", "box2"]
    
    override func viewDidLoad() {
        super.viewDidLoad()
        imageView.image = UIImage(named: "box0")
        imageView.contentMode = .ScaleAspectFit
    
        getDeviceMotion()
    }

    func getDeviceMotion()
    {
        if manager.deviceMotionAvailable {
            manager.deviceMotionUpdateInterval = 0.01
            manager.startDeviceMotionUpdatesToQueue(NSOperationQueue.mainQueue()) {
                [weak self] data, error in
                
                let rotation = atan2(data!.gravity.x, data!.gravity.y) - M_PI
                self?.imageView.transform = CGAffineTransformMakeRotation(CGFloat(rotation))
                
                
                if data!.userAcceleration.y < -2.0 {
                    self?.imageView.image = UIImage(named: (self?.images[Int(arc4random_uniform(3))])!)
                }
                
            }
        }

    }

}

