//
//  ViewController.swift
//  CoreMotionActivity
//
//  Created by NurWork on 21/12/15.
//  Copyright © 2015 RWTH Aachen Univesity. All rights reserved.
//

import UIKit
import CoreMotion

class ViewController: UIViewController {

    @IBOutlet weak var activityState: UILabel!
    @IBOutlet weak var steps: UILabel!
    @IBOutlet weak var distance: UILabel!
    @IBOutlet weak var speed: UILabel!
    @IBOutlet weak var floors: UILabel!
    
    
    let activityManager = CMMotionActivityManager()
    
    let pedoMeter = CMPedometer()
    
    let lengthFormatter = NSLengthFormatter()
    


    
    override func viewDidLoad() {
        
        super.viewDidLoad()
        
        lengthFormatter.numberFormatter.locale = NSLocale(localeIdentifier: "de-GR")
        
        let calendar = NSCalendar.currentCalendar()
        let date = NSDate()
        let unitFlags: NSCalendarUnit = [.Hour, .Day, .Month, .Year]
        let comps = NSCalendar.currentCalendar().components(unitFlags, fromDate: date)
        comps.hour = -24
        comps.minute = 0
        comps.second = 0
        let timeZone = NSTimeZone.systemTimeZone()
        calendar.timeZone = timeZone
        
        let yesterday = calendar.dateFromComponents(comps)!
        
        
        //Push
        if(CMMotionActivityManager.isActivityAvailable()){
            self.activityManager.startActivityUpdatesToQueue(NSOperationQueue.mainQueue()){ data in
                    if(data?.stationary == true){
                        self.activityState.text = "Stationary"
                    } else if (data?.walking == true){
                        self.activityState.text = "Walking"
                    } else if (data?.running == true){
                        self.activityState.text = "Running"
                    } else if (data?.automotive == true){
                        self.activityState.text = "Automotive"
                    } else if (data?.cycling == true){
                        self.activityState.text = "Cycling"
                    }
            }
        }
        
        
        if(CMPedometer.isStepCountingAvailable()){
            //new data
            let fromDate = NSDate(timeIntervalSinceNow: -86400 * 7)
            self.pedoMeter.queryPedometerDataFromDate(fromDate, toDate: NSDate()) { data, error in
                print(data!)
                dispatch_async(dispatch_get_main_queue()) {
                    if(error == nil){
                        self.steps.text = "\(data!.numberOfSteps)"
                    }
                }
            }
            
            //old data
            self.pedoMeter.startPedometerUpdatesFromDate(yesterday) { data, error in
                dispatch_async(dispatch_get_main_queue()) {
                    if(error == nil){
                        self.steps.text = "\(data!.numberOfSteps)"
                        
                        if let distance = data!.distance?.doubleValue {
                            self.distance.text = "\(self.lengthFormatter.stringFromMeters(distance))"
                            
                            
                            let time = data!.endDate.timeIntervalSinceDate(data!.startDate)
                            let speed = distance / time
                            self.speed.text = "\(self.lengthFormatter.stringFromMeters(speed)) / s"
                        }
                        
                        self.floors.text = "\(data!.floorsAscended!)"
                        
                    }
                }
            }
        }
    }
    

}

