
protocol Stringifyable {
	func stringify() -> String
}

// Raw Value Enumeration
enum TrainClass: String, Stringifyable {
	case S = "S-Bahn"
	case RB = "Regionalbahn"
	case RE = "Regional-Express"
	case IC = "Intercity"
	case ICE = "Intercity Express"
	static let allCases = [S, RB, RE, IC, ICE]
	
	func onTime() -> Bool {
		if self == .S || self == .ICE {
			return true
		}
		return false
	}
	
	func stringify() -> String {
		return self.rawValue
	}
}

TrainClass.ICE.onTime()
TrainClass.RE.onTime()



// Associated Value Enumeration
enum Transport {
	case plane(String, Int)
	case train(TrainClass, Int)
	case bus(Int)
	case car(String, String, Int)
}

var myRide = Transport.train(.ICE, 11)


func canWork(onRide: Transport) -> Bool {
	switch onRide {
	case .train(let trainClass, _):
		return trainClass == .ICE
	case .plane(_, _):
		return true
	default:
		return false
	}
}

canWork(myRide)

// GDL strike
myRide = .car("AC", "X", 1337)
canWork(myRide)





