//: Playground - noun: a place where people can play

import UIKit


class scoreBoard {
    
    var scoreLabel:String = "0"

/*
    //Computed property
    var score:Int
    {
        set
        {
            self.score = newValue //every new value update scoreLabel.text
            scoreLabel = "\(self.score)"
        }
        get // If you only implement this, it means the property is read-only and you cannot “set” any other variable in this get method  (similar to defining a stored property with let)
        {
            return self.score //“Attempting to modify/access score within its own setter/getter”. Calling indefinitely
        }
    }
*/
    
/*
    var score:Int = 10  // Or you can set it in an initializer
    {
        willSet
        {
                scoreLabel = "\(score)" //do not need to use self
                score *= newValue
        }
        // You don’t have to implement both didSet and willSet
    }


}
*/
}

struct temp {
    var value = 0.0
    let unit:Character //must handel it in initializers
    let convertable:Bool? //"let optional" must handel it in initializers
    var precision:Double? //"var optional" do not need to handel it in initializers
    
    init()//no parameters
    {
        //doing the bare minimum
        unit = "C"
        convertable = false
    }
    
    init(fromFahrenheit:Double)//with any number of parameters
    {
        self.init() //initializer delegation, to handel unit and convertable
        value = (fromFahrenheit - 32.0) / 1.8
    }
    
    init(_ value:Double, _ unit:Character)//with any number of parameters
    {
        self.value = value
        self.unit = unit
        self.convertable = false
    }
}

let temp1 = temp()
print("\(temp1.value)\(temp1.unit)")

let temp2 = temp(fromFahrenheit: 100)//must use first paramter name (unlike func)
print("\(temp2.value)\(temp2.unit)")

let temp3 = temp(33,"F")
print("\(temp3.value)\(temp3.unit)")





struct tempWithNoInits {
    var value = 0.0
    let unit:Character
    let convertable:Bool?
    var precision:Double?
}

// var temp4 = tempWithNoInits() //error, cannot use instance before initializing all stored properties
var temp4 = tempWithNoInits(value: 20, unit: "K", convertable: true, precision: 2) //defaultmemberwise initializer

/*

class tempClassWithNoInits {
    var value = 0.0
    let unit:Character
    let convertable:Bool?
    var precision:Double?
}
*/

//I could fix this by giving a default value for each property, or implement an initializer

class tempClassWithNoInits {
    var value = 0.0
    let unit:Character
    let convertable:Bool?
    var precision:Double?
    
    init (unit:Character,convertable:Bool?)
    {
        //doing the bare minimum
        self.unit = unit
        self.convertable = convertable
    }
}





class Food {
    var name: String
    init(name: String) { //beacuse classes do not get a memberwise init
        self.name = name
    }
    convenience init() {
        self.init(name: "[Unnamed]")//calls a designated
    }
}


class RecipeIngredient: Food {
    var quantity: Int
    init(name: String, quantity: Int) {
        self.quantity = quantity //its own
        super.init(name: name) //delegate up
    }
    override convenience init(name: String) { //overriding an initializer with same parameter names, types, number
        self.init(name: name, quantity: 1)
    }// with this, RecipeIngredient implements all of its superclass’s designated initializers. Therefore, it will inherit all of its superclass’s convenience initializers too.
    
    //init() is inherited
}

//All three of these initializers can be used to create new RecipeIngredient instances

let oneMysteryItem = RecipeIngredient()    
let oneBacon = RecipeIngredient(name: "Bacon")
let sixEggs = RecipeIngredient(name: "Eggs", quantity: 6)


class ShoppingListItem: RecipeIngredient {
    var purchased = false
    var description: String {
        var output = "\(quantity) x \(name)"
        output += purchased ? " ✔" : " ✘"
        return output
    }
    
    //because it hasn't any initializers (default or custom) ShoppingListItem inherit all superclass inits
    //init()
    //init(name)
    //init(name, quantity)
}

