//: Playground - noun: a place where people can play

import UIKit

struct Address //change to class and see the effect on where Alex, Sophia, Ali live
{
    var city:String = "AC"
    var zipCode:Int = 52072
        {
        didSet
        {
            if zipCode < 10000 || zipCode > 99999 //checking data validity
            {
                self.zipCode = 25072 //default
                print("Wong zip code")
            }
        }
    }
    
}

class Student
{
    var name:String
    var address:Address
    
    init(name:String,address:Address)
    {
        self.name = name
        self.address = address
    }
}

struct Institue
{
    let name:String
    var students:[Student]
}

struct University
{
    var students:[Student]
    var institues:[Institue]
    var address:Address
}

//Structs give you 2 default inits: init() and init(with all properties)
var address = Address() //or Address(city: "AC", zipCode: 12345)
address.zipCode = 12345

let Alex = Student(name: "Alex", address: address)
Alex.address.zipCode

address.zipCode = 45678
let Sophia = Student(name: "Sophia", address: address)
Sophia.address.zipCode

let Ali = Student(name: "Ali", address: address)
Ali.address.zipCode

Alex.address.zipCode //not what we want

Ali.address.zipCode = 54325
Sophia.address.zipCode //implicit sharing 


let institute1 = Institue(name: "Computer Science", students: [Alex, Sophia, Ali])
let institute2 = Institue(name: "Sport Center", students: [Sophia])

Sophia.address.zipCode = 89817

institute1.students[1].address.zipCode //Sophia's records are updated in institute 1
institute2.students[0].address.zipCode //Sophia's records are updated in institute 2





