
protocol Stringifyable {
	func stringify() -> String
}

class Person {
	var firstName: String
	var lastName: String
	var available = true
	
	init(firstName: String, lastName: String) {
		self.firstName = firstName
		self.lastName = lastName
	}
	
	func marry(other: Person, takeTheirName: Bool) {
		if (takeTheirName) {
			self.lastName = other.lastName
		}
		self.available = false
	}
	
	func stringify() -> String {
		return firstName + " " + lastName + (available ? " is still available!" : " is married.")
	}
}

var bradPitt = Person(firstName: "Brad", lastName: "Pitt")
var angelinaJolie = Person(firstName: "Angelina", lastName: "Jolie")
var guyWhoLooksLikeBradPitt = bradPitt

bradPitt.marry(angelinaJolie, takeTheirName: false)

bradPitt.stringify()
guyWhoLooksLikeBradPitt.stringify()

