
protocol Stringifyable {
	func stringify() -> String
}

class ShowMaster : Stringifyable {
	var name: String = "Hans"
	var lastName: String = "Meiser"
	var age: Int = 68
	
	func stringify() -> String {
		return name + " " + lastName + " (\(age))"
	}
}

class MobilePhone : Stringifyable {
	var name: String = "iPhone"
	var model: Int = 6
	
	func stringify() -> String {
		return name + " (\(model))"
	}
}

var person = ShowMaster()
var phone = MobilePhone()

var array: [Stringifyable] = [person, phone] //only because they conform to the same protocol, because arrays only store elements of the same type

for stringDing in array {
	stringDing.stringify()
	
	// although both implement name(), it is not part of the protocol
	// stringDing.name() ///< Compiler Error
}
