//Input array of names
let names = ["Simon Voelker", "Christian Corsten", "Nur Hamdan"]
//Output array of initials
let initials:[String]

//Step 1: split each name to first and last name parts
//Step 2: get the first character in each name part and concatinate them

//We will use split and map methods. These work on collection types and return in new collections




/*
//1. Split the first and last name
"Simon Voelker".characters.split (isSeparator: {(char:Character) -> Bool in
    return char == " "})

//Charcaters: A collection of Characters representing the String's extended grapheme clusters.

//split: Returns the maximal SubSequences of self [String.CharacterView], in order, that don’t contain elements satisfying the predicate isSeparator.

//isSeparator: (Self.Generator.Element) throws -> Bool. This means it takes a function type with one  argument is of Self.Generator.Element and returns Bool. Swift replaces the Self.Generator.Element type by looking back at the type that called split, which is Character.


//Map String.CharacterView name parts to Strings
let nameParts = "Simon Voelker".characters.split (isSeparator: {(char:Character) -> Bool in
    return char == " "})
    .map({(namePart:String.CharacterView) -> String in
        return String.init(namePart)}) //transform function



//map: Returns an Array containing the results of mapping transform over self

//transform: (Self.Generator.Element) throws -> T

//String.init: Construct the String corresponding to the given sequence of Unicode scalars.


//Store name parts in a tuple
var nameTuples = [(String,String)]() //array of tuples
nameTuples.append((nameParts[0],nameParts[1]))


//2. Map each name tuple to the first characters
initials = nameTuples.map({(tuple:(String,String)) -> String in
    return "\(tuple.0.characters.first!)\(tuple.1.characters.first!)"})

//We can do the assignmnet because map return nameTuples is an array

print(initials)
*/




/*

/* Both parts togther */

//1
let nameParts = "Simon Voelker".characters.split (isSeparator: {(char:Character) -> Bool in
    return char == " "})
    .map({(namePart:String.CharacterView) -> String in
        return String.init(namePart)})

var nameTuples = [(String,String)]()
nameTuples.append((nameParts[0],nameParts[1]))


//2
initials = nameTuples.map({(tuple:(String,String)) -> String in
return "\(tuple.0.characters.first!)\(tuple.1.characters.first!)"})
*/


/* Make code work for all names */

/*
let nameTuples = names.map({(name:String) -> (String,String) in

let nameParts = name.characters.split (isSeparator: {(char:Character) -> Bool in
return char == " "})
.map({(namePart:String.CharacterView) -> String in
return String.init(namePart)})

return (nameParts[0], nameParts[1])
})



initials = nameTuples.map({(tuple:(String,String)) -> String in
return "\(tuple.0.characters.first!)\(tuple.1.characters.first!)"})
*/


/* improve */
//Remove the clutter and convert to closure expressions
//a. type inference
//b. parameter names
//c. return of a single line
//d. trailing closure syntax

let nameTuples = names.map({(name:String) -> (String,String) in
    
    let nameParts = name.characters.split {$0 == " "}
        .map {String($0)}
    
    return (nameParts[0], nameParts[1])
})



initials = nameTuples.map {"\($0.0.characters.first!)\($0.1.characters.first!)"}







//Capturing by reference and by value
class MyClass
{
  var someProperty = "version 1.0"
}

var instance = MyClass()

var myClosure = {
    //[instance] //convert default capture by ref to capture by value
    //[instance.someProperty] //wouldn't work
    (appName : String) -> String in
    return appName + " " + instance.someProperty
}

print(myClosure("Clock"))

instance.someProperty = "version 2.0"
print(myClosure("Clock"))

instance = MyClass()
print(myClosure("Clock"))



//Clousers are reference types
//Nested funntion exmaple. Nested functions are a form of closuress

func calcDecrement(forDecrement total: Int) -> ()->Int
{
    var overallDecrement = 0
    
    func decrementer() -> Int {
        overallDecrement -= total
        return overallDecrement
    }
    
    return decrementer
    //overallDecrement normally goes out of scope here, but a reference to it is captured by decrementer
}

let decrem30 = calcDecrement(forDecrement: 30)
//now captured decrem30.overallDecrement is -30
print(decrem30()) //-30

let decrem10 = calcDecrement(forDecrement: 10)
//now captured decrem10.overallDecrement is -10
print(decrem10()) //-10

print(decrem30()) //decrem30.overallDecrement = -60



