import Foundation

protocol Stringifyable {
	func stringify() -> String
}

struct MapPoint: Stringifyable {
	var longitude: Double
	var latitude: Double
	
	func rhumbDistance(other: MapPoint) -> Double {
		let dLong = self.longitude - other.longitude
		let dLat = self.latitude - other.latitude
		return sqrt(dLong * dLong + dLat * dLat)
	}
	
	func stringify() -> String {
		return "(\(longitude); \(latitude))"
	}
}

var p1 = MapPoint(longitude: 10.0, latitude: 20.0)
var p2 = p1
p1.latitude = 30.0

p1.stringify()
p2.stringify()