//
//  ViewController.swift
//  TemperatureConverter
//
//  Created by Nur Al-huda Hamdan on 06/11/15.
//  Copyright © 2015 RWTH Aachen Univesity. All rights reserved.
//

import UIKit

class ViewController: UIViewController, UITextFieldDelegate {

    @IBOutlet weak var outputTex: UITextField!
    @IBOutlet weak var outputUnitControl: UISegmentedControl!
    
    @IBOutlet weak var inputTex: UITextField!
    @IBOutlet weak var inputUnitControl: UISegmentedControl!
    
    override func viewDidLoad() {
        super.viewDidLoad()
        inputTex.delegate = self
        outputTex.delegate = self
    }
    
    func updateOutputValue()
    {
        //read inputTex
        if let inTemp = Double(inputTex.text!) //inputTex.text!.doubleValue //(inputTex.text! as NSString).doubleValue //alternative: extensions
        {
            //read inUnit
            let inUnit = inputUnitControl.titleForSegmentAtIndex(inputUnitControl.selectedSegmentIndex)!
            
            //read outUnit
            let outUnit = outputUnitControl.titleForSegmentAtIndex(outputUnitControl.selectedSegmentIndex)!

            //convert
            let temperature = Temperature(value: inTemp, unit:TemperatureUnit(rawValue:inUnit)!)
            
            let outTemperature = temperature.convert(toTargetUnit: TemperatureUnit(rawValue:outUnit)!)
            
            //write result to outputTex
            outputTex.text = String(format:"%.2f", outTemperature.value)
            
            //notice: you cannot do string formatting with string interpolation
            //"\(outTemperature.value).2f"
            
        }
        else
        {
            let alert = UIAlertController(title: "Alert", message: "Please enter a number", preferredStyle: .Alert)
            
            alert.addAction(UIAlertAction(title: "OK", style: .Default, handler: nil)) //handler takes closure. This closure has no return value and takes the selected action object as its only parameter.
            self.presentViewController(alert, animated: true, completion: nil)
            
            /*
            //Example handler
           {(action:UIAlertAction!) in
                    let alertMessage = UIAlertController(title: "Confirmation", message: "Are you sure?", preferredStyle: .Alert)
                    alertMessage.addAction(UIAlertAction(title: "OK", style: .Default, handler: nil))
                    self.presentViewController(alertMessage, animated: true, completion: nil)
            }
            */
        }
    }

    @IBAction func inputValueChanged() {
        if inputTex.text! != "" //no need to check if inputTex.text is nil, it is always set to a value including "" empty string
        {
            updateOutputValue()
        }
        else
        {
            outputTex.text = ""
        }
    }
    
    
    @IBAction func unitChanged() {
        if inputTex.text! != ""
        {
            updateOutputValue()
        }
        else
        {
            outputTex.text = ""
        }
    }
    
    func textFieldShouldReturn(textField: UITextField) -> Bool {
        textField.resignFirstResponder()
        /*
        UIKit automatically sets the text field or text view that a user taps to be the first responder. To make the keyboard disappar, you must resign text field from being the first responder
        */
        return true
    }
    

}

/*
extension String
{
    static func doubleValue() -> Double?
    {
        if let doubleResult = Double(String(self))
        {
            return doubleResult
        }
        else
        {
            return nil
        }
    }
}
*/
