//: Playground - noun: a place where people can play

import UIKit


class Bird {
    //Shared attributes and methods for all birds
}

class RedBird:Bird
{
    let speed = 10.6
    let powerLevel = 6
}

//Act as an interface
protocol Game {
    var name: String { get  }
}

//Act as an interface
protocol MultiLevelGame:Game {
    var numberOfLevels: Int { get  }
    func moveToLevel(level:Int)
}

//Act as a delegate
protocol MultiLevelGameDelegate {
    func gameDidStart(game: MultiLevelGame)
    func game(game: MultiLevelGame, didStartNewLevel level: Int)
    func gameDidEnd(game: MultiLevelGame)
}

class AngryBirds:MultiLevelGame {
    let name = "Angry Birds"
    let numberOfLevels = 10
    var currentLevel = 1
    var delegate:MultiLevelGameDelegate?
    let birds = [Bird]()
    var gameState = "began"
    
    func moveToLevel(level: Int) {
        //
    }
    
    func play()
    {
        switch gameState
        {
        case "began": delegate?.gameDidStart(self)
        case "movingToNextLevel": moveToLevel(currentLevel+1)
        case "ended": delegate?.gameDidEnd(self)
        default: break
        }
    }
    
}


class GameSocreBoard:MultiLevelGameDelegate
{
    var currentScore = 0
    func gameDidStart(game: MultiLevelGame)
    {
        //Add game to score board
        if let specificGame = game as? AngryBirds { //Test for conformance
            print("Started a new game of \(specificGame.name) with \(specificGame.numberOfLevels) levels")
        }
    }
    func game(game: MultiLevelGame, didStartNewLevel level: Int)
        
    {
        //Compute level score
    }
    func gameDidEnd(game: MultiLevelGame)
    {
        //Compute final score
    }
}


let scoreBoard = GameSocreBoard()
let game = AngryBirds()
game.delegate = scoreBoard
game.play()






















