//
//  VDSClientDelegate.h
//  ViconDataStreamFramework
//
//  Created by Marty Pye on 31/03/14.
//  Copyright (c) 2014 Media Computing Group. All rights reserved.
//

#import <Foundation/Foundation.h>

@class VDSClient;
@protocol VDSDelegate <NSObject>

@required
/**
 *  Is called everytime the vicon updates the subjects, and needs to be implemented by the application using this framework.
 *
 *  @param subjects The dictionary of subjects. The subjects can be accessed by their name as the key. 
 *  The name of the subjects is defined in the Vicon Nexus Tracker application.
 */
- (void) viconDidUpdateSubjects:(NSDictionary *) subjects;

@optional
/**
 *  Is called when the vicon client disconnects.
 *
 *  @param theClient The client which disconnected
 */
- (void) viconDidDisconnect:(VDSClient *) theClient;

/**
 *  Is called when the Vicon Server reports an error. This method can be implemented for debugging purposes.
 *
 *  @param theError The error reported by the Vicon Server.
 */
- (void) viconDidReportError:(NSError*) theError;

/**
 *  Is called everytime the Vicon system updates the unlabled markers.
 *
 *  @param unlabledMarkers The set of unlabled markers.
 */
- (void) viconDidUpdateUnlabeledMarkers:(NSSet*) unlabledMarkers;

@end
