//
//  VDSMarker.h
//  ViconDataStreamFramework
//
//  Created by Marty Pye on 31/03/14.
//  Copyright (c) 2014 Media Computing Group. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "CATransform3D+Vector.h"


/**
 *  VDSMarker is basically a reflective marker, and can store it's position in 3D-space. The marker does not know
 *  its orientation, i.e. rotation information. For that see VDSSegment.
 */
@interface VDSMarker : NSObject

/**
 *  Creates a new marker object.
 *
 *  @param theCoordinates The coordinates in 3D space of the marker.
 *  @param theName        The marker's name, as defined in the Vicon Nexus Tracker.
 *
 *  @return A marker instance
 */
+ (VDSMarker *)markerWithCoordinates:(CAVector3)theCoordinates andName:(NSString *)theName;

/**
 *  The coordinates in 3D-space of the marker.
 */
@property (readonly) CAVector3 coordinates;

/**
 *  The marker's name, as defined in the Vicon Nexus Tracker.
 */
@property (copy, readonly) NSString *name;

/**
 *  The x-coordinate of the marker
 */
@property (readonly, getter = x) double x;

/**
 *  The y-coordinate of the marker
 */
@property (readonly, getter = y) double y;

/**
 *  The z-coordinate of the marker
 */
@property (readonly, getter = z) double z;

/**
 *  If YES, then the marker is visible. If NO, then the marker is currently occluded and not visible for the Vicon cameras.
 */
@property (readwrite) BOOL visible;

@end
