//
//  VDSRotation.h
//  ViconDataStreamFramework
//
//  Created by Marty Pye on 04/04/14.
//  Copyright (c) 2014 Media Computing Group. All rights reserved.
//

@interface VDSRotation : NSObject

@property (readonly) double eulerX __deprecated_msg("use localEulerX instead");
@property (readonly) double eulerY __deprecated_msg("use localEulerY instead");
@property (readonly) double eulerZ __deprecated_msg("use localEulerZ instead");

/**
 *  The local rotation information (with respect to the parent segment) as a Euler angle around X.
 */
@property (readwrite) double localEulerX;

/**
 *  The local rotation information (with respect to the parent segment) as a Euler angle around Y.
 */
@property (readwrite) double localEulerY;

/**
 *  The local rotation information (with respect to the parent segment) as a Euler angle around Z.
 */
@property (readwrite) double localEulerZ;


/**
 *  The global rotation information (with respect to the origin of the tracking space) as a Euler angle around X.
 */
@property (readwrite) double globalEulerX;

/**
 *  The global rotation information (with respect to the origin of the tracking space) as a Euler angle around Y.
 */
@property (readwrite) double globalEulerY;

/**
 *  The global rotation information (with respect to the origin of the tracking space) as a Euler angle around Z.
 */
@property (readwrite) double globalEulerZ;

/**
 *  No idea what static rotation is. Is always reported as 0 from the Vicon...
 */
@property (readwrite) double staticEulerX;

/**
 *  No idea what static rotation is. Is always reported as 0 from the Vicon...
 */
@property (readwrite) double staticEulerY;

/**
 *  No idea what static rotation is. Is always reported as 0 from the Vicon...
 */
@property (readwrite) double staticEulerZ;

@end
