#include <metal_stdlib>
#include <simd/simd.h>

using namespace metal;


typedef struct {
    matrix_float4x4 transform;
} Uniforms;

typedef struct {
    packed_float2 position;
    packed_float3 color;
} Vertex;

typedef struct {
    float4 position [[ position ]];
    half4  color;
} Varyings;

vertex Varyings VF(
	device Vertex* vertex_array [[ buffer(0) ]],
	constant Uniforms& uniforms [[ buffer(1) ]],
	unsigned int vid [[ vertex_id ]]
) {
    Varyings out;
	
	Vertex v = vertex_array[vid];
	
    float4 position = float4(v.position, 0.0, 1.0);
    out.position = uniforms.transform * position;
	
	out.color = half4(half3(v.color), 1.0);
    
    return out;
}

fragment half4 FF(
	Varyings in [[ stage_in ]]
) {
    return half4(1.0 - in.color.xyz, in.color.w);
}
