//
//  AppDelegate.m
//  ViconExampleApp
//
//  Created by Marty Pye on 25/06/14.
//  Copyright (c) 2014 Media Computing Group. All rights reserved.
//

#import "AppDelegate.h"

@implementation AppDelegate

- (void)applicationDidFinishLaunching:(NSNotification *)aNotification
{
    // Insert code here to initialize your application
    [self setupVicon];
}

- (void) setupVicon;
{
    self.viconClient = [VDSClient sharedClient];
    [self.viconClient setDelegate:self];
    [self.viconClient startStreaming];
    [self.viconClient logAllData:YES]; // for debugging
}

# pragma mark required
// required: called every time Vicon updates positions
- (void) viconDidUpdateSubjects:(NSDictionary *)subjects;
{
    // string to be displayed
    NSMutableString *trackingListString = [[NSMutableString alloc] init];
    
    // iterate over all subjects
    for (NSString *aSubjectName in subjects) {
        VDSSubject *currentSubject = [subjects objectForKey:aSubjectName];
        
        // iterate over all segments of the current subject
        for (NSString *segmentName in currentSubject.segments) {
            VDSSegment *currentSegment = [currentSubject.segments objectForKey:segmentName];
            
            // append segment description to label
            NSString *segmentInfo = [NSString stringWithFormat:@"\n%@", currentSegment.description];
            [trackingListString appendString:segmentInfo];
        }
         
        // iterate over all markers of the current subject
        for (NSString *markerName in currentSubject.markers) {
            VDSMarker *currentMarker = [currentSubject.markers objectForKey:markerName];
            
            // append maker description to label
            NSString *markerInfo = [NSString stringWithFormat:@"\n%@", currentMarker.description];
            [trackingListString appendString:markerInfo];
        }
    }
    
    // update UI
    self.trackingListLabel.stringValue = trackingListString;
}


# pragma mark optional

- (void) viconDidReportError:(NSError *)theError
{
    NSLog(@"%@", theError);
}

- (void) viconDidDisconnect:(VDSClient *)theClient;
{
    
}

- (void) viconDidUpdateUnlabeledMarkers:(NSSet *)unlabledMarkers;
{
    // String for UI Label
    NSMutableString *unlabeledMarkersString = [[NSMutableString alloc] init];
    
    // iterate over all unlabeled markers
    for (VDSMarker *marker in unlabledMarkers) {
        NSString *markerInfo = [NSString stringWithFormat:@"\n%@", marker.description];
        [unlabeledMarkersString appendString:markerInfo];
    }
    
    // update UI
    self.unlabeledMarkersLabel.stringValue = unlabeledMarkersString;
}

@end
