/*
 * Decompiled with CFR 0.152.
 */
package de.mcp.cutcad.view;

import de.mcp.cutcad.application.Grid;
import de.mcp.cutcad.model.ObjectContainer;
import de.mcp.cutcad.model.STLMesh;
import de.mcp.cutcad.model.primitives.Shape;
import de.mcp.cutcad.model.primitives.Vector2D;
import de.mcp.cutcad.view.Drawable3D;
import de.mcp.cutcad.view.DrawingViewFrame;
import de.mcp.cutcad.view.Transformation;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PVector;
import processing.opengl.PGraphics3D;
import remixlab.proscene.Scene;
import toxi.geom.mesh.Mesh3D;
import toxi.processing.ToxiclibsSupport;

public class DrawingView3D {
    private DrawingViewFrame frame;
    private PApplet application;
    private Scene scene;
    private Transformation transform;
    private ToxiclibsSupport gfx;
    private PGraphics3D context;
    private Drawable3D axes = new Axes3D();
    private Grid grid3D;

    public DrawingView3D(PGraphics3D context, DrawingViewFrame frame, Transformation transform, PApplet application) {
        this.context = context;
        this.frame = frame;
        this.transform = transform;
        this.application = application;
        this.grid3D = new Grid(this.transform, (PGraphics)this.context);
        this.createScene();
        this.gfx = new ToxiclibsSupport(this.application, (PGraphics)this.context);
    }

    private void createScene() {
        Scene scene = new Scene(this.application, this.context);
        scene.disableKeyboardHandling();
        scene.disableMouseHandling();
        scene.setGridIsDrawn(false);
        scene.setAxisIsDrawn(false);
        scene.setRadius(10000.0f);
        scene.camera().setPosition(new PVector(500.0f, 550.0f, 1500.0f));
        this.scene = scene;
    }

    public void setInteractionEnabled(boolean interactionEnabled) {
        if (interactionEnabled) {
            this.scene.enableMouseHandling();
        } else {
            this.scene.disableMouseHandling();
        }
    }

    public boolean mouseOver(Vector2D mousePosition) {
        return mousePosition.x() > this.frame.origin.x() && mousePosition.x() <= this.frame.origin.x() + this.frame.size.x() && mousePosition.y() > this.frame.origin.y() && mousePosition.y() <= this.frame.origin.y() + this.frame.size.y();
    }

    public void draw(ObjectContainer container) {
        this.context.beginDraw();
        this.scene.beginDraw();
        this.context.background(150);
        this.axes.draw3D((PGraphics)this.context, this.transform);
        this.grid3D.draw2D((PGraphics)this.context, this.transform);
        for (Shape s : container.allShapes()) {
            s.getGShape().draw3D((PGraphics)this.context, this.transform);
        }
        STLMesh meshSTL = container.getSTLMesh();
        if (meshSTL.isStlImported()) {
            this.context.fill(200);
            this.context.stroke(180);
            if (meshSTL.isPosChanged()) {
                meshSTL.center();
            }
            if (meshSTL.isRotChanged()) {
                meshSTL.rotate();
            }
            this.gfx.mesh((Mesh3D)meshSTL.getSTLMesh());
        }
        this.scene.endDraw();
        this.context.endDraw();
        this.application.image((PImage)this.context, this.frame.origin.x(), this.frame.origin.y());
    }

    private class Axes3D
    implements Drawable3D {
        private Axes3D() {
        }

        @Override
        public void draw3D(PGraphics context, Transformation t) {
            context.strokeWeight(10.0f);
            context.stroke(context.color(255, 100, 100));
            context.line(0.0f, 0.0f, 0.0f, 1000.0f, 0.0f, 0.0f);
            context.stroke(context.color(100, 255, 100));
            context.line(0.0f, 0.0f, 0.0f, 0.0f, 1000.0f, 0.0f);
            context.stroke(context.color(100, 100, 255));
            context.line(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1000.0f);
            context.stroke(context.color(0, 0, 0));
            context.strokeWeight(1.0f);
        }
    }
}

