/*
 * Decompiled with CFR 0.152.
 */
package de.mcp.cutcad.view;

import de.mcp.cutcad.application.CutCADApplet;
import de.mcp.cutcad.application.Grid;
import de.mcp.cutcad.model.ObjectContainer;
import de.mcp.cutcad.model.primitives.Vector2D;
import de.mcp.cutcad.view.Drawable2D;
import de.mcp.cutcad.view.DrawingViewFrame;
import de.mcp.cutcad.view.Transformation;
import java.util.List;
import processing.core.PGraphics;
import processing.core.PImage;

public class DrawingView2D {
    private CutCADApplet application;
    private PGraphics context;
    private DrawingViewFrame frame;
    private Transformation transform;
    private Grid grid;
    private Drawable2D axes = new Axes2D();

    public DrawingView2D(PGraphics context, DrawingViewFrame frame, Transformation transform, CutCADApplet application) {
        this.context = context;
        this.frame = frame;
        this.transform = transform;
        this.application = application;
        this.grid = new Grid(transform, context);
    }

    public void applyTransformation(Transformation transform) {
        this.context.scale(transform.getScale());
        this.context.translate(-transform.getTranslation().x(), -transform.getTranslation().y());
    }

    public void draw(ObjectContainer container) {
        this.context.beginDraw();
        this.context.background(150);
        this.applyTransformation(this.transform);
        List<Drawable2D> allDrawables = container.allDrawables();
        allDrawables.add(this.application.getSelectedTool());
        allDrawables.add(this.axes);
        allDrawables.add(this.grid);
        for (Drawable2D d : allDrawables) {
            if (!(d instanceof Drawable2D)) continue;
            d.draw2D(this.context, this.transform);
        }
        this.context.endDraw();
        this.application.image((PImage)this.context, this.frame.origin.x(), this.frame.origin.y());
    }

    public Vector2D getOrigin() {
        return this.frame.origin;
    }

    public Vector2D positionRelativeToView(Vector2D inPosition) {
        Vector2D newPos = inPosition.sub(this.getOrigin());
        newPos.set(newPos.x() / this.getTransformation().getScale(), newPos.y() / this.getTransformation().getScale());
        newPos.addSelf(this.getTransformation().getTranslation());
        newPos = newPos.scale(1.0f / this.getTransformation().getScale());
        return newPos;
    }

    public boolean containsPoint(Vector2D point) {
        return this.frame.containsPoint(point);
    }

    public Transformation getTransformation() {
        return this.transform;
    }

    public boolean mouseOver(Vector2D mousePosition) {
        return mousePosition.x() > this.frame.origin.x() && mousePosition.x() <= this.frame.origin.x() + this.frame.size.x() && mousePosition.x() > this.frame.origin.x() && mousePosition.y() <= this.frame.origin.y() + this.frame.size.y();
    }

    private class Axes2D
    implements Drawable2D {
        private Axes2D() {
        }

        @Override
        public void draw2D(PGraphics context, Transformation transform) {
            context.strokeWeight(10.0f);
            context.stroke(context.color(255, 100, 100));
            context.line(0.0f, 0.0f, 800.0f, 0.0f);
            context.stroke(context.color(100, 255, 100));
            context.line(0.0f, 0.0f, 0.0f, 800.0f);
            context.stroke(context.color(0, 0, 0));
            context.strokeWeight(1.0f);
        }
    }
}

